/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.authentication;

import java.util.HashMap;
import java.util.Map;
import org.jboss.aerogear.android.authentication.AuthenticationConfiguration;
import org.jboss.aerogear.android.authentication.AuthenticationModule;
import org.jboss.aerogear.android.authentication.OnAuthenticationCreatedListener;
import org.jboss.aerogear.android.authentication.basic.HttpBasicAuthenticationConfiguration;
import org.jboss.aerogear.android.authentication.basic.HttpBasicAuthenticationConfigurationProvider;
import org.jboss.aerogear.android.authentication.digest.HttpDigestAuthenticationConfiguration;
import org.jboss.aerogear.android.authentication.digest.HttpDigestAuthenticationConfigurationProvider;
import org.jboss.aerogear.android.core.ConfigurationProvider;

public class AuthenticationManager {
    private static Map<String, AuthenticationModule> modules = new HashMap<String, AuthenticationModule>();
    private static Map<Class<? extends AuthenticationConfiguration<?>>, ConfigurationProvider<?>> configurationProviderMap = new HashMap();
    private static OnAuthenticationCreatedListener onAuthenticationCreatedListener = new OnAuthenticationCreatedListener(){

        @Override
        public void onAuthenticationCreated(AuthenticationConfiguration<?> configuration, AuthenticationModule module) {
            modules.put(configuration.getName(), module);
        }
    };

    private AuthenticationManager() {
    }

    public static <CFG extends AuthenticationConfiguration<CFG>> void registerConfigurationProvider(Class<CFG> configurationClass, ConfigurationProvider<CFG> provider) {
        configurationProviderMap.put(configurationClass, provider);
    }

    public static <CFG extends AuthenticationConfiguration<CFG>> CFG config(String name, Class<CFG> authenticationConfigurationClass) {
        ConfigurationProvider<?> provider = configurationProviderMap.get(authenticationConfigurationClass);
        if (provider == null) {
            throw new IllegalArgumentException("Configuration not registered!");
        }
        return (CFG)((AuthenticationConfiguration)provider.newConfiguration()).setName(name).addOnAuthenticationCreatedListener(onAuthenticationCreatedListener);
    }

    public static AuthenticationModule getModule(String name) {
        return modules.get(name);
    }

    static {
        HttpBasicAuthenticationConfigurationProvider basicConfigurationProvider = new HttpBasicAuthenticationConfigurationProvider();
        AuthenticationManager.registerConfigurationProvider(HttpBasicAuthenticationConfiguration.class, basicConfigurationProvider);
        HttpDigestAuthenticationConfigurationProvider digestConfigurationProvider = new HttpDigestAuthenticationConfigurationProvider();
        AuthenticationManager.registerConfigurationProvider(HttpDigestAuthenticationConfiguration.class, digestConfigurationProvider);
    }
}

