/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.authentication.impl;

import android.util.Log;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import org.jboss.aerogear.android.Callback;
import org.jboss.aerogear.android.authentication.AbstractAuthenticationModule;
import org.jboss.aerogear.android.authentication.AuthorizationFields;
import org.jboss.aerogear.android.authentication.impl.DigestAuthenticationModuleRunner;
import org.jboss.aerogear.android.code.ModuleFields;
import org.jboss.aerogear.android.http.HeaderAndBody;
import org.jboss.aerogear.android.http.HttpException;

public class HttpDigestAuthenticationModule
extends AbstractAuthenticationModule {
    private static final String TAG = HttpDigestAuthenticationModule.class.getSimpleName();
    private boolean isLoggedIn = false;
    private final DigestAuthenticationModuleRunner runner;

    protected HttpDigestAuthenticationModule(URL baseURL, String loginEndpoint, String logoutEndpoint, Integer timeout) {
        this.runner = new DigestAuthenticationModuleRunner(baseURL, loginEndpoint, logoutEndpoint, timeout);
    }

    @Override
    public URL getBaseURL() {
        return this.runner.getBaseURL();
    }

    @Override
    public String getLoginEndpoint() {
        return this.runner.getLoginEndpoint();
    }

    @Override
    public String getLogoutEndpoint() {
        return this.runner.getLogoutEndpoint();
    }

    @Override
    public String getEnrollEndpoint() {
        return this.runner.getEnrollEndpoint();
    }

    @Override
    public void enroll(Map<String, String> userData, final Callback<HeaderAndBody> callback) {
        THREAD_POOL_EXECUTOR.execute(new Runnable(){

            @Override
            public void run() {
                callback.onFailure((Exception)new UnsupportedOperationException());
            }
        });
    }

    @Override
    public void login(final String username, final String password, final Callback<HeaderAndBody> callback) {
        THREAD_POOL_EXECUTOR.execute(new Runnable(){

            @Override
            public void run() {
                HeaderAndBody result = null;
                Exception exception = null;
                try {
                    result = HttpDigestAuthenticationModule.this.runner.onLogin(username, password);
                    HttpDigestAuthenticationModule.this.isLoggedIn = true;
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)"Error with Login", (Throwable)e);
                    exception = e;
                }
                if (exception == null) {
                    callback.onSuccess((Object)result);
                } else {
                    callback.onFailure(exception);
                }
            }
        });
    }

    @Override
    public void logout(final Callback<Void> callback) {
        THREAD_POOL_EXECUTOR.execute(new Runnable(){

            @Override
            public void run() {
                Exception exception = null;
                try {
                    HttpDigestAuthenticationModule.this.runner.onLogout();
                    HttpDigestAuthenticationModule.this.isLoggedIn = false;
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)"Error with Login", (Throwable)e);
                    exception = e;
                }
                if (exception == null) {
                    callback.onSuccess(null);
                } else {
                    callback.onFailure(exception);
                }
            }
        });
    }

    @Override
    public boolean isLoggedIn() {
        return this.isLoggedIn;
    }

    @Override
    public AuthorizationFields getAuthorizationFields(URI requestUri, String method, byte[] requestBody) {
        AuthorizationFields fields = new AuthorizationFields();
        fields.addHeader("Authorization", this.runner.getAuthorizationHeader(requestUri, method, requestBody));
        return fields;
    }

    @Override
    public boolean retryLogin() {
        return this.runner.retryLogin();
    }

    @Override
    public void login(Map<String, String> loginData, Callback<HeaderAndBody> callback) {
        this.login(loginData.get("loginName"), loginData.get("password"), callback);
    }

    public ModuleFields loadModule(URI relativeURI, String httpMethod, byte[] requestBody) {
        AuthorizationFields fields = this.getAuthorizationFields(relativeURI, httpMethod, requestBody);
        ModuleFields moduleFields = new ModuleFields();
        moduleFields.setHeaders(fields.getHeaders());
        moduleFields.setQueryParameters(fields.getQueryParameters());
        return moduleFields;
    }

    public boolean handleError(HttpException exception) {
        return this.isLoggedIn() && this.retryLogin();
    }
}

