/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.authentication.test.basic;

import android.support.test.runner.AndroidJUnit4;
import android.util.Log;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.aerogear.android.authentication.basic.HttpBasicAuthenticationModule;
import org.jboss.aerogear.android.authentication.test.AuthenticationModuleTest;
import org.jboss.aerogear.android.authentication.test.MainActivity;
import org.jboss.aerogear.android.authentication.test.util.PatchedActivityInstrumentationTestCase;
import org.jboss.aerogear.android.authentication.test.util.VoidCallback;
import org.jboss.aerogear.android.core.Callback;
import org.jboss.aerogear.android.pipe.Pipe;
import org.jboss.aerogear.android.pipe.PipeManager;
import org.jboss.aerogear.android.pipe.http.HeaderAndBody;
import org.jboss.aerogear.android.pipe.module.PipeModule;
import org.jboss.aerogear.android.pipe.rest.RestfulPipeConfiguration;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=AndroidJUnit4.class)
public class HttpBasicIntegrationTest
extends PatchedActivityInstrumentationTestCase
implements AuthenticationModuleTest {
    private static final URL CONTROLLER_URL;
    private static final RestfulPipeConfiguration AUTOBOT_CONFIG;
    protected static final String TAG;

    public HttpBasicIntegrationTest() {
        super(MainActivity.class);
    }

    @Ignore
    @Test
    public void testBadLogin() throws InterruptedException {
        HttpBasicAuthenticationModule basicAuthModule = new HttpBasicAuthenticationModule(CONTROLLER_URL);
        final AtomicBoolean success = new AtomicBoolean(false);
        AUTOBOT_CONFIG.module((PipeModule)basicAuthModule);
        basicAuthModule.login("fakeUser", "fakePass", (Callback)new Callback<HeaderAndBody>(){

            public void onFailure(Exception arg0) {
            }

            public void onSuccess(HeaderAndBody arg0) {
            }
        });
        Pipe autobots = AUTOBOT_CONFIG.forClass(String.class);
        final CountDownLatch latch = new CountDownLatch(1);
        autobots.read((Callback)new Callback<List<String>>(){

            public void onSuccess(List<String> data) {
                success.set(true);
                latch.countDown();
            }

            public void onFailure(Exception e) {
                latch.countDown();
            }
        });
        latch.await(10L, TimeUnit.SECONDS);
        Assert.assertFalse((boolean)success.get());
    }

    @Ignore
    @Test
    public void testLogin() throws InterruptedException {
        HttpBasicAuthenticationModule basicAuthModule = new HttpBasicAuthenticationModule(CONTROLLER_URL);
        final AtomicBoolean success = new AtomicBoolean(false);
        AUTOBOT_CONFIG.module((PipeModule)basicAuthModule);
        basicAuthModule.login("john", "123", (Callback)new Callback<HeaderAndBody>(){

            public void onFailure(Exception ex) {
                Log.e((String)TAG, (String)ex.getMessage(), (Throwable)ex);
            }

            public void onSuccess(HeaderAndBody arg0) {
            }
        });
        Pipe autobots = AUTOBOT_CONFIG.forClass(String.class);
        final CountDownLatch latch = new CountDownLatch(1);
        autobots.read((Callback)new Callback<List<String>>(){

            public void onSuccess(List<String> data) {
                success.set(true);
                latch.countDown();
            }

            public void onFailure(Exception ex) {
                Log.e((String)TAG, (String)ex.getMessage(), (Throwable)ex);
                latch.countDown();
            }
        });
        latch.await(10L, TimeUnit.SECONDS);
        Assert.assertTrue((boolean)success.get());
    }

    @Ignore
    @Test
    public void testLogout() throws InterruptedException {
        HttpBasicAuthenticationModule basicAuthModule = new HttpBasicAuthenticationModule(CONTROLLER_URL);
        final AtomicBoolean success = new AtomicBoolean(false);
        AUTOBOT_CONFIG.module((PipeModule)basicAuthModule);
        basicAuthModule.login("john", "123", (Callback)new Callback<HeaderAndBody>(){

            public void onFailure(Exception arg0) {
            }

            public void onSuccess(HeaderAndBody arg0) {
            }
        });
        Pipe autobots = AUTOBOT_CONFIG.forClass(String.class);
        final CountDownLatch latch = new CountDownLatch(1);
        autobots.read((Callback)new Callback<List<String>>(){

            public void onSuccess(List<String> data) {
                success.set(true);
                latch.countDown();
            }

            public void onFailure(Exception e) {
                latch.countDown();
            }
        });
        latch.await(10L, TimeUnit.SECONDS);
        Assert.assertTrue((boolean)success.get());
        final CountDownLatch latch2 = new CountDownLatch(1);
        basicAuthModule.logout((Callback)new VoidCallback());
        autobots.read((Callback)new Callback<List<String>>(){

            public void onSuccess(List<String> data) {
                success.set(true);
                latch2.countDown();
            }

            public void onFailure(Exception e) {
                success.set(false);
                latch2.countDown();
            }
        });
        latch2.await(10L, TimeUnit.SECONDS);
        Assert.assertFalse((boolean)success.get());
    }

    static {
        TAG = HttpBasicIntegrationTest.class.getSimpleName();
        try {
            CONTROLLER_URL = new URL("http://controller-aerogear.rhcloud.com/aerogear-controller-demo/autobots");
            AUTOBOT_CONFIG = (RestfulPipeConfiguration)PipeManager.config((String)"autobots", RestfulPipeConfiguration.class);
            AUTOBOT_CONFIG.withUrl(CONTROLLER_URL);
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
    }
}

