/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.impl.helper;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.aerogear.android.authentication.impl.loader.support.SupportAuthenticationModuleAdapter;
import org.jboss.aerogear.android.impl.reflection.FieldNotFoundException;
import org.mockito.Mockito;

public class UnitTestUtils {
    public static void setPrivateField(Object target, String fieldName, Object value) throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        List<Field> fields = UnitTestUtils.getAllFields(new ArrayList<Field>(), target.getClass());
        for (Field field : fields) {
            if (!field.getName().equals(fieldName)) continue;
            field.setAccessible(true);
            field.set(target, value);
            return;
        }
        throw new FieldNotFoundException(target.getClass(), fieldName);
    }

    public static Object getPrivateField(Object target, String fieldName) throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field field = target.getClass().getDeclaredField(fieldName);
        field.setAccessible(true);
        return field.get(target);
    }

    public static Object getSuperPrivateField(Object target, String fieldName) throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field field = target.getClass().getSuperclass().getDeclaredField(fieldName);
        field.setAccessible(true);
        return field.get(target);
    }

    public static <T> T getPrivateField(Object target, String fieldName, Class<T> type) throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field field = target.getClass().getDeclaredField(fieldName);
        field.setAccessible(true);
        return (T)field.get(target);
    }

    public static <T> T replaceWithSpy(Object target, String fieldName, Class<T> type) throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field field = target.getClass().getDeclaredField(fieldName);
        field.setAccessible(true);
        Object object = field.get(target);
        object = Mockito.spy((Object)object);
        UnitTestUtils.setPrivateField(target, fieldName, object);
        return (T)object;
    }

    public static List<Field> getAllFields(List<Field> fields, Class<?> type) {
        Collections.addAll(fields, type.getDeclaredFields());
        if (type.getSuperclass() != null) {
            fields = UnitTestUtils.getAllFields(fields, type.getSuperclass());
        }
        return fields;
    }

    public static void callMethod(Object target, String methodName) {
        try {
            Method method = target.getClass().getDeclaredMethod(methodName, new Class[0]);
            method.setAccessible(true);
            method.invoke(target, new Object[0]);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(UnitTestUtils.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(UnitTestUtils.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
        catch (InvocationTargetException ex) {
            Logger.getLogger(UnitTestUtils.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
        catch (NoSuchMethodException ex) {
            Logger.getLogger(UnitTestUtils.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
        catch (SecurityException ex) {
            Logger.getLogger(UnitTestUtils.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
    }

    public static Object getPrivateEnum(Class<SupportAuthenticationModuleAdapter> klass, String enumName, String constantName) {
        for (Class<?> declaredClass : klass.getDeclaredClasses()) {
            if (!declaredClass.getCanonicalName().equals(enumName)) continue;
            for (Object t : declaredClass.getEnumConstants()) {
                if (!t.toString().equals(constantName)) continue;
                return t;
            }
        }
        return null;
    }
}

