/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.authentication.impl.loader;

import android.content.Context;
import android.content.Loader;
import android.os.Bundle;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.aerogear.android.Callback;
import org.jboss.aerogear.android.authentication.AuthenticationModule;
import org.jboss.aerogear.android.authentication.impl.HttpBasicAuthenticationModule;
import org.jboss.aerogear.android.authentication.impl.loader.AuthenticationModuleAdapter;
import org.jboss.aerogear.android.authentication.impl.loader.EnrollLoader;
import org.jboss.aerogear.android.authentication.impl.loader.LoginLoader;
import org.jboss.aerogear.android.authentication.impl.loader.LogoutLoader;
import org.jboss.aerogear.android.authentication.test.MainActivity;
import org.jboss.aerogear.android.http.HeaderAndBody;
import org.jboss.aerogear.android.impl.util.PatchedActivityInstrumentationTestCase;
import org.jboss.aerogear.android.impl.util.VoidCallback;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class LoadersTest
extends PatchedActivityInstrumentationTestCase<MainActivity> {
    final HeaderAndBody response = new HeaderAndBody(new byte[]{1, 2, 3, 4}, new HashMap());
    AuthenticationModule module;
    VoidCallback callback;

    public LoadersTest() {
        super(MainActivity.class);
    }

    @Override
    public void setUp() {
        this.module = (AuthenticationModule)Mockito.mock(AuthenticationModule.class);
        this.callback = new VoidCallback();
        ((AuthenticationModule)Mockito.doAnswer(new ResponseAnswer<HeaderAndBody>(this.response)).when((Object)this.module)).enroll((Map)Matchers.any(Map.class), (Callback)Matchers.any(Callback.class));
        ((AuthenticationModule)Mockito.doAnswer(new ResponseAnswer<HeaderAndBody>(this.response)).when((Object)this.module)).login(Matchers.anyString(), Matchers.anyString(), (Callback)Matchers.any(Callback.class));
        ((AuthenticationModule)Mockito.doAnswer(new ResponseAnswer<HeaderAndBody>(this.response)).when((Object)this.module)).login(Matchers.anyMapOf(String.class, String.class), (Callback)Matchers.any(Callback.class));
        ((AuthenticationModule)Mockito.doAnswer(new ResponseAnswer<Object>(null)).when((Object)this.module)).logout((Callback)Matchers.any(Callback.class));
        Mockito.when((Object)this.module.isLoggedIn()).thenReturn((Object)Boolean.FALSE);
    }

    public void testEnrollLoader() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("test", "test");
        EnrollLoader loader = new EnrollLoader((Context)this.getActivity(), (Callback)this.callback, this.module, params);
        loader.loadInBackground();
        ((AuthenticationModule)Mockito.verify((Object)this.module)).enroll((Map)Matchers.eq(params), (Callback)Matchers.any(Callback.class));
    }

    public void testLogoutLoader() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("test", "test");
        LogoutLoader loader = new LogoutLoader((Context)this.getActivity(), (Callback)this.callback, this.module);
        loader.loadInBackground();
        ((AuthenticationModule)Mockito.verify((Object)this.module)).logout((Callback)Matchers.any(Callback.class));
    }

    public void testLoginLoader() {
        HashMap loginData = new HashMap();
        LoginLoader loader = new LoginLoader((Context)this.getActivity(), (Callback)this.callback, this.module, loginData);
        loader.loadInBackground();
        ((AuthenticationModule)Mockito.verify((Object)this.module)).login(Matchers.anyMapOf(String.class, String.class), (Callback)Matchers.any(Callback.class));
    }

    public void testLoaderDoesNotCache() throws IllegalArgumentException, NoSuchFieldException, IllegalAccessException, InterruptedException, MalformedURLException {
        AuthenticationModule module = (AuthenticationModule)Mockito.spy((Object)new HttpBasicAuthenticationModule(new URL("http://test.com")));
        CountDownLatch latch = new CountDownLatch(1);
        final AtomicBoolean loggedIn = new AtomicBoolean(false);
        final AtomicInteger loginCount = new AtomicInteger(0);
        final AtomicInteger logoutCount = new AtomicInteger(0);
        AuthenticationModuleAdapter adapter = new AuthenticationModuleAdapter(this.getActivity(), module, "ignore");
        adapter = (AuthenticationModuleAdapter)Mockito.spy((Object)adapter);
        ((AuthenticationModuleAdapter)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                Bundle bundle = (Bundle)invocation.getArguments()[1];
                AuthenticationModuleAdapter.Methods method = (AuthenticationModuleAdapter.Methods)bundle.get("org.jboss.aerogear.android.authentication.loader.AuthenticationModuleAdapter.METHOD");
                switch (method) {
                    case LOGIN: {
                        loginCount.incrementAndGet();
                        loggedIn.set(true);
                        break;
                    }
                    case LOGOUT: {
                        logoutCount.incrementAndGet();
                        loggedIn.set(false);
                    }
                }
                ((Callback)bundle.getSerializable("org.jboss.aerogear.android.authentication.loader.AuthenticationModuleAdapter.CALLBACK")).onSuccess(null);
                return Mockito.mock(Loader.class);
            }
        }).when((Object)adapter)).onCreateLoader(Matchers.anyInt(), (Bundle)Matchers.any(Bundle.class));
        ((AuthenticationModule)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                return loggedIn.get();
            }
        }).when((Object)module)).isLoggedIn();
        adapter.login("evilname", "password", (Callback)new VoidCallback(latch));
        LoadersTest.assertTrue((boolean)latch.await(1L, TimeUnit.SECONDS));
        latch = new CountDownLatch(1);
        adapter.logout((Callback)new VoidCallback());
        adapter.login("evilname", "password", (Callback)new VoidCallback(latch));
        LoadersTest.assertTrue((boolean)latch.await(2L, TimeUnit.SECONDS));
        adapter.logout((Callback)new VoidCallback());
        LoadersTest.assertEquals((int)2, (int)loginCount.get());
        LoadersTest.assertEquals((int)2, (int)logoutCount.get());
    }

    public void testLoginLoaderDoesNotCache() throws IllegalArgumentException, NoSuchFieldException, IllegalAccessException, InterruptedException, MalformedURLException {
        HttpBasicAuthenticationModule module = new HttpBasicAuthenticationModule(new URL("http://test.com"));
        CountDownLatch latch = new CountDownLatch(1);
        final AtomicInteger loginCount = new AtomicInteger(0);
        final AtomicInteger logoutCount = new AtomicInteger(0);
        AuthenticationModuleAdapter adapter = new AuthenticationModuleAdapter(this.getActivity(), (AuthenticationModule)module, "ignore");
        adapter = (AuthenticationModuleAdapter)Mockito.spy((Object)adapter);
        ((AuthenticationModuleAdapter)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                Bundle bundle = (Bundle)invocation.getArguments()[1];
                AuthenticationModuleAdapter.Methods method = (AuthenticationModuleAdapter.Methods)bundle.get("org.jboss.aerogear.android.authentication.loader.AuthenticationModuleAdapter.METHOD");
                switch (method) {
                    case LOGIN: {
                        loginCount.incrementAndGet();
                        break;
                    }
                    case LOGOUT: {
                        logoutCount.incrementAndGet();
                    }
                }
                ((Callback)bundle.getSerializable("org.jboss.aerogear.android.authentication.loader.AuthenticationModuleAdapter.CALLBACK")).onSuccess(null);
                return Mockito.mock(Loader.class);
            }
        }).when((Object)adapter)).onCreateLoader(Matchers.anyInt(), (Bundle)Matchers.any(Bundle.class));
        adapter.login("evilname", "password", (Callback)new VoidCallback(latch));
        LoadersTest.assertTrue((boolean)latch.await(1L, TimeUnit.SECONDS));
        latch = new CountDownLatch(1);
        adapter.logout((Callback)new VoidCallback());
        adapter.login("evilname", "password", (Callback)new VoidCallback(latch));
        LoadersTest.assertTrue((boolean)latch.await(2L, TimeUnit.SECONDS));
        LoadersTest.assertEquals((int)2, (int)loginCount.get());
        LoadersTest.assertEquals((int)1, (int)logoutCount.get());
    }

    private final class ResponseAnswer<T>
    implements Answer<Void> {
        T response;

        public ResponseAnswer(T response) {
            this.response = response;
        }

        public Void answer(InvocationOnMock invocation) throws Throwable {
            Callback callback = null;
            for (Object argument : invocation.getArguments()) {
                if (!(argument instanceof Callback)) continue;
                callback = (Callback)argument;
            }
            if (callback == null) {
                throw new IllegalArgumentException("A callback was not passed");
            }
            callback.onSuccess(this.response);
            return null;
        }
    }
}

