/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.vertx.shell;

import io.vertx.core.cli.annotations.Argument;
import io.vertx.core.cli.annotations.Description;
import io.vertx.core.cli.annotations.Name;
import io.vertx.core.cli.annotations.Summary;
import io.vertx.ext.shell.command.CommandProcess;
import java.util.Properties;
import org.jberet.vertx.shell.CommandBase;

@Name(value="restart-job-execution")
@Summary(value="Restart a batch job execution")
public final class RestartJobExecutionCommand
extends CommandBase {
    private long jobExecutionId;
    private Properties jobParameters;

    @Description(value="the job execution id to restart")
    @Argument(index=0, argName="jobExecutionId")
    public void setJobExecutionId(long i) {
        this.jobExecutionId = i;
    }

    @Description(value="job parameters as a comma-separated list of key-value pairs")
    @Argument(index=1, argName="jobParameters", required=false)
    public void setJobParameters(String params) {
        this.jobParameters = RestartJobExecutionCommand.parseJobParameters(params);
    }

    public void process(CommandProcess process) {
        try {
            long restartJobExecutionId = jobOperator.restart(this.jobExecutionId, this.jobParameters);
            process.write(String.format("Restarted previous job execution %s, and the new job execution id is %s%n", this.jobExecutionId, restartJobExecutionId));
            process.end();
        }
        catch (Exception e) {
            RestartJobExecutionCommand.failed(process, e);
        }
    }
}

