/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.vertx.shell;

import io.vertx.core.cli.annotations.Description;
import io.vertx.core.cli.annotations.Name;
import io.vertx.core.cli.annotations.Option;
import io.vertx.core.cli.annotations.Summary;
import io.vertx.ext.shell.command.CommandProcess;
import java.util.List;
import javax.batch.runtime.StepExecution;
import org.jberet.vertx.shell.CommandBase;
import org.jberet.vertx.shell.GetStepExecutionCommand;

@Name(value="list-step-executions")
@Summary(value="List step executions belonging to a job execution")
public final class ListStepExecutionsCommand
extends CommandBase {
    private long jobExecutionId;

    @Description(value="the job execution id whose step executions to list")
    @Option(required=true, longName="job-execution-id", shortName="j")
    public void setJobExecutionId(long i) {
        this.jobExecutionId = i;
    }

    public void process(CommandProcess process) {
        try {
            List stepExecutions = jobOperator.getStepExecutions(this.jobExecutionId);
            process.write(String.format("Step executions in job execution %s:%n", this.jobExecutionId));
            for (StepExecution stepExecution : stepExecutions) {
                process.write(GetStepExecutionCommand.format(stepExecution.getStepExecutionId(), stepExecution.getBatchStatus()));
            }
            process.end();
        }
        catch (Exception e) {
            ListStepExecutionsCommand.failed(process, e);
        }
    }
}

