/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.vertx.shell;

import io.vertx.core.cli.annotations.Argument;
import io.vertx.core.cli.annotations.Description;
import io.vertx.core.cli.annotations.Name;
import io.vertx.core.cli.annotations.Summary;
import io.vertx.ext.shell.command.CommandProcess;
import java.util.Properties;
import org.jberet.vertx.shell.CommandBase;

@Name(value="start-job")
@Summary(value="Start a batch job execution")
public final class StartJobCommand
extends CommandBase {
    private String jobName;
    private Properties jobParameters;

    @Description(value="the name of the job to start")
    @Argument(index=0, argName="jobName")
    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    @Description(value="job parameters as a comma-separated list of key-value pairs")
    @Argument(index=1, argName="jobParameters", required=false)
    public void setJobParameters(String params) {
        this.jobParameters = StartJobCommand.parseJobParameters(params);
    }

    public void process(CommandProcess process) {
        try {
            long jobExecutionId = jobOperator.start(this.jobName, this.jobParameters);
            process.write(String.format("Started job %s, and the job execution id is %s%n", this.jobName, jobExecutionId));
            process.end();
        }
        catch (Exception e) {
            StartJobCommand.failed(process, e);
        }
    }
}

