/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.vertx.shell;

import io.vertx.core.cli.annotations.Description;
import io.vertx.core.cli.annotations.Name;
import io.vertx.core.cli.annotations.Option;
import io.vertx.core.cli.annotations.Summary;
import io.vertx.ext.shell.command.CommandProcess;
import java.util.List;
import javax.batch.runtime.JobExecution;
import javax.batch.runtime.JobInstance;
import org.jberet.vertx.shell.CommandBase;
import org.jberet.vertx.shell.GetStepExecutionCommand;

@Name(value="list-job-executions")
@Summary(value="List job executions")
public final class ListJobExecutionsCommand
extends CommandBase {
    private String jobName;
    private boolean running;

    @Description(value="the name of the job")
    @Option(required=true, longName="job-name", shortName="j")
    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    @Description(value="whether to return only running job executions")
    @Option(longName="running", shortName="r", flag=true)
    public void setRunning(boolean r) {
        this.running = r;
    }

    public void process(CommandProcess process) {
        try {
            if (this.running) {
                List runningExecutions = jobOperator.getRunningExecutions(this.jobName);
                process.write(String.format("Running job executions for job %s:%n%s%n ", this.jobName, runningExecutions));
            } else {
                process.write(String.format("Job executions for job %s:%n", this.jobName));
                List jobInstances = jobOperator.getJobInstances(this.jobName, 0, Integer.MAX_VALUE);
                for (JobInstance jobInstance : jobInstances) {
                    List jobExecutions = jobOperator.getJobExecutions(jobInstance);
                    for (JobExecution jobExecution : jobExecutions) {
                        process.write(GetStepExecutionCommand.format(jobExecution.getExecutionId(), jobExecution.getBatchStatus()));
                    }
                }
            }
            process.end();
        }
        catch (Exception e) {
            ListJobExecutionsCommand.failed(process, e);
        }
    }
}

