/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.vertx.shell;

import io.vertx.core.cli.annotations.Argument;
import io.vertx.core.cli.annotations.Description;
import io.vertx.core.cli.annotations.Name;
import io.vertx.core.cli.annotations.Option;
import io.vertx.core.cli.annotations.Summary;
import io.vertx.ext.shell.command.CommandProcess;
import java.util.List;
import javax.batch.runtime.Metric;
import javax.batch.runtime.StepExecution;
import org.jberet.vertx.shell.CommandBase;

@Name(value="get-step-execution")
@Summary(value="Get step execution details")
public final class GetStepExecutionCommand
extends CommandBase {
    private long stepExecutionId;
    private long jobExecutionId;

    @Description(value="the step execution id")
    @Argument(index=0, argName="stepExecutionId")
    public void setStepExecutionId(long i) {
        this.stepExecutionId = i;
    }

    @Description(value="the step execution id")
    @Option(longName="step-execution-id", shortName="s")
    public void setStepExecutionIdOption(long i) {
        this.stepExecutionId = i;
    }

    @Description(value="the job execution id")
    @Option(required=true, longName="job-execution-id", shortName="j")
    public void setJobExecutionId(long i) {
        this.jobExecutionId = i;
    }

    public void process(CommandProcess process) {
        try {
            List stepExecutions = jobOperator.getStepExecutions(this.jobExecutionId);
            boolean found = false;
            for (StepExecution se : stepExecutions) {
                long sid = se.getStepExecutionId();
                if (sid != this.stepExecutionId) continue;
                found = true;
                process.write(GetStepExecutionCommand.format("execution id", sid)).write(GetStepExecutionCommand.format("step name", se.getStepName())).write(GetStepExecutionCommand.format("batch status", se.getBatchStatus())).write(GetStepExecutionCommand.format("exit status", se.getExitStatus())).write(GetStepExecutionCommand.format("start time", se.getStartTime())).write(GetStepExecutionCommand.format("end time", se.getEndTime()));
                for (Metric m : se.getMetrics()) {
                    process.write(GetStepExecutionCommand.format(m.getType(), m.getValue()));
                }
                process.write(GetStepExecutionCommand.format("persistent data", se.getPersistentUserData()));
            }
            if (!found) {
                process.write(String.format("Didn't find step execution with step execution id %s and job execution id %s", this.stepExecutionId, this.jobExecutionId));
            }
            process.end();
        }
        catch (Exception e) {
            GetStepExecutionCommand.failed(process, e);
        }
    }

    static String format(Object label, Object value) {
        return String.format("%-25s %s%n", label, value);
    }
}

