/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.rest.service;

import jakarta.batch.operations.JobExecutionAlreadyCompleteException;
import jakarta.batch.operations.JobExecutionIsRunningException;
import jakarta.batch.operations.JobExecutionNotMostRecentException;
import jakarta.batch.operations.JobExecutionNotRunningException;
import jakarta.batch.operations.JobOperator;
import jakarta.batch.operations.JobRestartException;
import jakarta.batch.operations.JobSecurityException;
import jakarta.batch.operations.JobStartException;
import jakarta.batch.operations.NoSuchJobException;
import jakarta.batch.operations.NoSuchJobExecutionException;
import jakarta.batch.operations.NoSuchJobInstanceException;
import jakarta.batch.runtime.BatchRuntime;
import jakarta.batch.runtime.JobExecution;
import jakarta.batch.runtime.JobInstance;
import jakarta.batch.runtime.StepExecution;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.jberet.job.model.Job;
import org.jberet.operations.AbstractJobOperator;
import org.jberet.operations.DelegatingJobOperator;
import org.jberet.rest.commons.util.JsonJobMapper;
import org.jberet.rest.entity.JobEntity;
import org.jberet.rest.entity.JobExecutionEntity;
import org.jberet.rest.entity.JobInstanceEntity;
import org.jberet.rest.entity.StepExecutionEntity;
import org.jberet.runtime.JobInstanceImpl;

public final class JobService {
    private static final JobService instance = new JobService();
    private final JobOperator jobOperator = BatchRuntime.getJobOperator();

    private JobService() {
    }

    public static JobService getInstance() {
        return instance;
    }

    public JobExecutionEntity start(String jobXmlName, Properties jobParameters) throws JobStartException, JobSecurityException, NoSuchJobExecutionException {
        long jobExecutionId = this.jobOperator.start(jobXmlName, jobParameters);
        return new JobExecutionEntity(this.jobOperator.getJobExecution(jobExecutionId), this.jobOperator.getJobInstance(jobExecutionId).getInstanceId());
    }

    public JobExecutionEntity submit(String jobContent, Properties jobParameters) throws JobStartException, JobSecurityException, NoSuchJobExecutionException {
        AbstractJobOperator abstractJobOperator = this.unwrapJobOperator();
        Job job = JsonJobMapper.toJob(jobContent);
        long jobExecutionId = abstractJobOperator.start(job, jobParameters);
        return new JobExecutionEntity(this.jobOperator.getJobExecution(jobExecutionId), this.jobOperator.getJobInstance(jobExecutionId).getInstanceId());
    }

    public JobEntity[] getJobs() throws JobSecurityException {
        Set jobNames = this.jobOperator.getJobNames();
        JobEntity[] result = new JobEntity[jobNames.size()];
        int i = 0;
        for (String jobName : jobNames) {
            int jobInstanceCount = this.jobOperator.getJobInstanceCount(jobName);
            List runningExecutions = this.jobOperator.getRunningExecutions(jobName);
            JobEntity je = new JobEntity(jobName, jobInstanceCount, runningExecutions.size());
            result[i++] = je;
        }
        return result;
    }

    public JobInstanceEntity[] getJobInstances(String jobName, int start, int count) throws NoSuchJobException, JobSecurityException {
        List jobInstances = this.jobOperator.getJobInstances(jobName, start, count);
        int len = jobInstances.size();
        JobInstanceEntity[] jobInstanceData = new JobInstanceEntity[len];
        for (int i = 0; i < len; ++i) {
            JobInstance e = (JobInstance)jobInstances.get(i);
            jobInstanceData[i] = new JobInstanceEntity(e, this.jobOperator.getJobExecutions(e));
        }
        return jobInstanceData;
    }

    public JobInstanceEntity getJobInstance(long executionId) throws NoSuchJobExecutionException, JobSecurityException {
        JobInstance jobInstance = this.jobOperator.getJobInstance(executionId);
        return new JobInstanceEntity(jobInstance, this.jobOperator.getJobExecutions(jobInstance));
    }

    public int getJobInstanceCount(String jobName) throws NoSuchJobException, JobSecurityException {
        return this.jobOperator.getJobInstanceCount(jobName);
    }

    public JobExecutionEntity getJobExecution(long jobExecutionId) throws NoSuchJobExecutionException, JobSecurityException {
        JobExecution jobExecution = this.jobOperator.getJobExecution(jobExecutionId);
        return new JobExecutionEntity(jobExecution, this.jobOperator.getJobInstance(jobExecutionId).getInstanceId());
    }

    public JobExecutionEntity[] getJobExecutions(int count, long jobInstanceId, long jobExecutionId1) throws NoSuchJobInstanceException, JobSecurityException {
        JobInstance jobInstance = null;
        if (jobExecutionId1 > 0L) {
            jobInstance = this.jobOperator.getJobInstance(jobExecutionId1);
        }
        List jobExecutions = this.jobOperator.getJobExecutions(jobInstance);
        int countAll = jobExecutions.size();
        if (count <= 0) {
            count = countAll;
        } else if (count > countAll) {
            count = countAll;
        }
        JobExecutionEntity[] jobExecutionEntities = new JobExecutionEntity[count];
        int i = countAll - 1;
        for (int j = 0; j < count && i >= 0; --i, ++j) {
            JobExecution e = (JobExecution)jobExecutions.get(i);
            jobExecutionEntities[j] = new JobExecutionEntity(e, this.jobOperator.getJobInstance(e.getExecutionId()).getInstanceId());
        }
        return jobExecutionEntities;
    }

    public void abandon(long jobExecutionId) throws NoSuchJobExecutionException, JobExecutionIsRunningException, JobSecurityException {
        this.jobOperator.abandon(jobExecutionId);
    }

    public void stop(long jobExecutionId) throws NoSuchJobExecutionException, JobExecutionNotRunningException, JobSecurityException {
        this.jobOperator.stop(jobExecutionId);
    }

    public JobExecutionEntity restart(long jobExecutionId, Properties restartParameters) throws JobExecutionAlreadyCompleteException, NoSuchJobExecutionException, JobExecutionNotMostRecentException, JobRestartException, JobSecurityException {
        long restartExecutionId = this.jobOperator.restart(jobExecutionId, restartParameters);
        return new JobExecutionEntity(this.jobOperator.getJobExecution(restartExecutionId), this.jobOperator.getJobInstance(restartExecutionId).getInstanceId());
    }

    public JobExecutionEntity resubmit(String jobDefinition, long jobExecutionId, Properties restartParameters) throws JobExecutionAlreadyCompleteException, NoSuchJobExecutionException, JobExecutionNotMostRecentException, JobRestartException, JobSecurityException {
        if (jobDefinition != null && jobDefinition.length() > 60) {
            Job job = JsonJobMapper.toJob(jobDefinition);
            AbstractJobOperator abstractJobOperator = this.unwrapJobOperator();
            JobInstanceImpl jobInstance = (JobInstanceImpl)abstractJobOperator.getJobInstance(jobExecutionId);
            jobInstance.setUnsubstitutedJob(job);
        }
        long restartExecutionId = this.jobOperator.restart(jobExecutionId, restartParameters);
        return new JobExecutionEntity(this.jobOperator.getJobExecution(restartExecutionId), this.jobOperator.getJobInstance(restartExecutionId).getInstanceId());
    }

    public JobExecutionEntity[] getRunningExecutions(String jobName) throws NoSuchJobException, JobSecurityException {
        List executionIds = this.jobOperator.getRunningExecutions(jobName);
        int len = executionIds.size();
        JobExecutionEntity[] runningExecutions = new JobExecutionEntity[len];
        for (int i = len - 1; i >= 0; --i) {
            long e = (Long)executionIds.get(i);
            runningExecutions[len - 1 - i] = new JobExecutionEntity(this.jobOperator.getJobExecution(e), this.jobOperator.getJobInstance(e).getInstanceId());
        }
        return runningExecutions;
    }

    public StepExecutionEntity[] getStepExecutions(long jobExecutionId) throws NoSuchJobExecutionException, JobSecurityException {
        List stepExecutions = this.jobOperator.getStepExecutions(jobExecutionId);
        int len = stepExecutions.size();
        StepExecutionEntity[] stepExecutionData = new StepExecutionEntity[len];
        for (int i = 0; i < len; ++i) {
            stepExecutionData[i] = new StepExecutionEntity((StepExecution)stepExecutions.get(i));
        }
        return stepExecutionData;
    }

    private AbstractJobOperator unwrapJobOperator() {
        AbstractJobOperator abstractJobOperator = this.jobOperator instanceof DelegatingJobOperator ? (AbstractJobOperator)((DelegatingJobOperator)this.jobOperator).getDelegate() : (AbstractJobOperator)this.jobOperator;
        return abstractJobOperator;
    }
}

