/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.rest.entity;

import jakarta.batch.runtime.JobExecution;
import jakarta.batch.runtime.JobInstance;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.io.Serializable;
import java.util.List;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(propOrder={"instanceId", "jobName", "numberOfJobExecutions", "latestJobExecutionId"})
public final class JobInstanceEntity
implements JobInstance,
Serializable {
    private static final long serialVersionUID = 2427272964201557394L;
    @XmlElement
    private long instanceId;
    @XmlElement
    private String jobName;
    @XmlElement
    private int numberOfJobExecutions;
    @XmlElement
    private long latestJobExecutionId;

    public JobInstanceEntity() {
    }

    public JobInstanceEntity(JobInstance jobInstance, List<JobExecution> jobExecutions) {
        this.instanceId = jobInstance.getInstanceId();
        this.jobName = jobInstance.getJobName();
        this.numberOfJobExecutions = jobExecutions.size();
        if (this.numberOfJobExecutions > 0) {
            this.latestJobExecutionId = jobExecutions.get(this.numberOfJobExecutions - 1).getExecutionId();
        }
    }

    public long getInstanceId() {
        return this.instanceId;
    }

    public String getJobName() {
        return this.jobName;
    }

    public int getNumberOfJobExecutions() {
        return this.numberOfJobExecutions;
    }

    public long getLatestJobExecutionId() {
        return this.latestJobExecutionId;
    }
}

