/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.rest.entity;

import jakarta.batch.operations.BatchRuntimeException;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(propOrder={"type", "message", "stackTrace"})
public final class BatchExceptionEntity
implements Serializable {
    private static final long serialVersionUID = 810435611118287431L;
    @XmlElement
    private final Class<? extends BatchRuntimeException> type;
    @XmlElement
    private final String message;
    @XmlElement
    private final String stackTrace;

    public BatchExceptionEntity(BatchRuntimeException ex) {
        this.type = ex.getClass();
        this.message = ex.getMessage();
        this.stackTrace = BatchExceptionEntity.toString((Throwable)ex);
    }

    public Class<? extends BatchRuntimeException> getType() {
        return this.type;
    }

    public String getMessage() {
        return this.message;
    }

    public String getStackTrace() {
        return this.stackTrace;
    }

    private static String toString(Throwable origin) {
        String string;
        StringWriter writer = new StringWriter();
        try {
            origin.printStackTrace(new PrintWriter(writer));
            string = writer.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable e) {
                return origin.toString();
            }
        }
        writer.close();
        return string;
    }

    private static Throwable getRootCause(Throwable origin) {
        List<Throwable> list = BatchExceptionEntity.getThrowableList(origin);
        return list.isEmpty() ? null : list.get(list.size() - 1);
    }

    private static List<Throwable> getThrowableList(Throwable throwable) {
        ArrayList<Throwable> list = new ArrayList<Throwable>();
        while (throwable != null) {
            if (!list.contains(throwable)) {
                list.add(throwable);
                throwable = throwable.getCause();
                continue;
            }
            throw new IllegalArgumentException("Loop chain detected: ", throwable);
        }
        return list;
    }
}

