/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.rest.commons.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.batch.operations.BatchRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.jberet.job.model.Decision;
import org.jberet.job.model.DecisionBuilder;
import org.jberet.job.model.Flow;
import org.jberet.job.model.FlowBuilder;
import org.jberet.job.model.Job;
import org.jberet.job.model.JobBuilder;
import org.jberet.job.model.Split;
import org.jberet.job.model.SplitBuilder;
import org.jberet.job.model.Step;
import org.jberet.job.model.StepBuilder;
import org.jberet.job.model.XmlAttribute;
import org.jberet.job.model.XmlElement;
import org.jberet.rest.commons._private.RestCommonsMessages;

public final class JsonJobMapper {
    public static final String[] EMPTY_STRING_ARRAY = new String[0];

    private JsonJobMapper() {
    }

    public static Job toJob(String json) throws BatchRuntimeException {
        JsonNode jobNode;
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            jobNode = objectMapper.readTree(json).get(XmlElement.JOB.getLocalName());
        }
        catch (IOException e) {
            throw RestCommonsMessages.MESSAGES.failToReadJobDefinition(e);
        }
        String jobId = JsonJobMapper.getRequiredTextValue(jobNode, XmlAttribute.ID, XmlElement.JOB);
        JobBuilder jobBuilder = new JobBuilder(jobId);
        JsonJobMapper.mapJob(jobNode, jobBuilder);
        return jobBuilder.build();
    }

    private static void mapJob(JsonNode jobNode, JobBuilder jobBuilder) {
        JsonJobMapper.applyBooleanValue(jobNode, XmlAttribute.RESTARTABLE, xva$0 -> jobBuilder.restartable(new boolean[]{xva$0}));
        jobBuilder.properties(JsonJobMapper.parseProperties(jobNode, null));
        JsonJobMapper.mapListeners(jobNode.get(XmlElement.LISTENERS.getLocalName()), (arg_0, arg_1) -> ((JobBuilder)jobBuilder).listener(arg_0, arg_1));
        JsonJobMapper.mapFlows(jobNode.get(XmlElement.FLOW.getLocalName()), arg_0 -> ((JobBuilder)jobBuilder).flow(arg_0));
        JsonJobMapper.mapSplits(jobNode.get(XmlElement.SPLIT.getLocalName()), arg_0 -> ((JobBuilder)jobBuilder).split(arg_0));
        JsonJobMapper.mapSteps(jobNode.get(XmlElement.STEP.getLocalName()), arg_0 -> ((JobBuilder)jobBuilder).step(arg_0));
        JsonJobMapper.mapDecisions(jobNode.get(XmlElement.DECISION.getLocalName()), arg_0 -> ((JobBuilder)jobBuilder).decision(arg_0));
    }

    private static void mapFlows(JsonNode flowNode, Consumer<Flow> applyMethod) {
        if (flowNode == null) {
            return;
        }
        if (flowNode.isArray()) {
            Iterator elements = flowNode.elements();
            while (elements.hasNext()) {
                JsonJobMapper.mapSingleFlow((JsonNode)elements.next(), applyMethod);
            }
        } else {
            JsonJobMapper.mapSingleFlow(flowNode, applyMethod);
        }
    }

    private static void mapSingleFlow(JsonNode singleFlowNode, Consumer<Flow> applyMethod) {
        FlowBuilder flowBuilder = new FlowBuilder(JsonJobMapper.getRequiredTextValue(singleFlowNode, XmlAttribute.ID, XmlElement.FLOW));
        JsonJobMapper.applyTextValue(singleFlowNode, XmlAttribute.NEXT, arg_0 -> ((FlowBuilder)flowBuilder).next(arg_0));
        JsonJobMapper.mapTransitions(singleFlowNode, null, flowBuilder, null);
        JsonJobMapper.mapFlows(singleFlowNode.get(XmlElement.FLOW.getLocalName()), arg_0 -> ((FlowBuilder)flowBuilder).flow(arg_0));
        JsonJobMapper.mapSplits(singleFlowNode.get(XmlElement.SPLIT.getLocalName()), arg_0 -> ((FlowBuilder)flowBuilder).split(arg_0));
        JsonJobMapper.mapSteps(singleFlowNode.get(XmlElement.STEP.getLocalName()), arg_0 -> ((FlowBuilder)flowBuilder).step(arg_0));
        JsonJobMapper.mapDecisions(singleFlowNode.get(XmlElement.DECISION.getLocalName()), arg_0 -> ((FlowBuilder)flowBuilder).decision(arg_0));
        applyMethod.accept(flowBuilder.build());
    }

    private static void mapSplits(JsonNode splitNode, Consumer<Split> applyMethod) {
        if (splitNode == null) {
            return;
        }
        if (splitNode.isArray()) {
            Iterator elements = splitNode.elements();
            while (elements.hasNext()) {
                JsonJobMapper.mapSingleSplit((JsonNode)elements.next(), applyMethod);
            }
        } else {
            JsonJobMapper.mapSingleSplit(splitNode, applyMethod);
        }
    }

    private static void mapSingleSplit(JsonNode singleSplitNode, Consumer<Split> applyMethod) {
        SplitBuilder splitBuilder = new SplitBuilder(JsonJobMapper.getRequiredTextValue(singleSplitNode, XmlAttribute.ID, XmlElement.SPLIT));
        JsonJobMapper.applyTextValue(singleSplitNode, XmlAttribute.NEXT, arg_0 -> ((SplitBuilder)splitBuilder).next(arg_0));
        JsonJobMapper.mapFlows(singleSplitNode.get(XmlElement.FLOW.getLocalName()), arg_0 -> ((SplitBuilder)splitBuilder).flow(arg_0));
        applyMethod.accept(splitBuilder.build());
    }

    private static void mapDecisions(JsonNode decisionNode, Consumer<Decision> applyMethod) {
        if (decisionNode == null) {
            return;
        }
        if (decisionNode.isArray()) {
            Iterator elements = decisionNode.elements();
            while (elements.hasNext()) {
                JsonJobMapper.mapSingleDecision((JsonNode)elements.next(), applyMethod);
            }
        } else {
            JsonJobMapper.mapSingleDecision(decisionNode, applyMethod);
        }
    }

    private static void mapSingleDecision(JsonNode singleDecisionNode, Consumer<Decision> applyMethod) {
        DecisionBuilder decisionBuilder = new DecisionBuilder(JsonJobMapper.getRequiredTextValue(singleDecisionNode, XmlAttribute.ID, XmlElement.JOB, XmlElement.DECISION), JsonJobMapper.getRequiredTextValue(singleDecisionNode, XmlAttribute.REF, XmlElement.JOB, XmlElement.DECISION));
        decisionBuilder.properties(JsonJobMapper.parseProperties(singleDecisionNode, null));
        JsonJobMapper.mapTransitions(singleDecisionNode, null, null, decisionBuilder);
        applyMethod.accept(decisionBuilder.build());
    }

    private static void mapTransitions(JsonNode containingNode, StepBuilder stepBuilder, FlowBuilder flowBuilder, DecisionBuilder decisionBuilder) {
        JsonJobMapper.mapTransitionSingleOrArray(containingNode, XmlElement.END, endNodeSingle -> JsonJobMapper.mapSingleEnd(endNodeSingle, stepBuilder, flowBuilder, decisionBuilder));
        JsonJobMapper.mapTransitionSingleOrArray(containingNode, XmlElement.FAIL, failNodeSingle -> JsonJobMapper.mapSingleFail(failNodeSingle, stepBuilder, flowBuilder, decisionBuilder));
        JsonJobMapper.mapTransitionSingleOrArray(containingNode, XmlElement.STOP, stopNodeSingle -> JsonJobMapper.mapSingleStop(stopNodeSingle, stepBuilder, flowBuilder, decisionBuilder));
        JsonJobMapper.mapTransitionSingleOrArray(containingNode, XmlElement.NEXT, nextNodeSingle -> JsonJobMapper.mapSingleNext(nextNodeSingle, stepBuilder, flowBuilder, decisionBuilder));
    }

    private static void mapTransitionSingleOrArray(JsonNode containingNode, XmlElement transitionElementName, Consumer<JsonNode> function) {
        JsonNode elementNode = containingNode.get(transitionElementName.getLocalName());
        if (elementNode != null) {
            if (elementNode.isArray()) {
                Iterator elements = elementNode.elements();
                while (elements.hasNext()) {
                    function.accept((JsonNode)elements.next());
                }
            } else {
                function.accept(elementNode);
            }
        }
    }

    private static void mapSingleEnd(JsonNode singleEndNode, StepBuilder stepBuilder, FlowBuilder flowBuilder, DecisionBuilder decisionBuilder) {
        String[] stringArray;
        String on = JsonJobMapper.getRequiredTextValue(singleEndNode, XmlAttribute.ON, XmlElement.END);
        String exitStatus = singleEndNode.path(XmlAttribute.EXIT_STATUS.getLocalName()).asText(null);
        if (exitStatus == null) {
            stringArray = EMPTY_STRING_ARRAY;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = exitStatus;
        }
        String[] newExitStatus = stringArray;
        if (stepBuilder != null) {
            stepBuilder.endOn(on).exitStatus(newExitStatus);
        } else if (flowBuilder != null) {
            flowBuilder.endOn(on).exitStatus(newExitStatus);
        } else if (decisionBuilder != null) {
            decisionBuilder.endOn(on).exitStatus(newExitStatus);
        }
    }

    private static void mapSingleFail(JsonNode singleFailNode, StepBuilder stepBuilder, FlowBuilder flowBuilder, DecisionBuilder decisionBuilder) {
        String[] stringArray;
        String on = JsonJobMapper.getRequiredTextValue(singleFailNode, XmlAttribute.ON, XmlElement.FAIL);
        String exitStatus = singleFailNode.path(XmlAttribute.EXIT_STATUS.getLocalName()).asText(null);
        if (exitStatus == null) {
            stringArray = EMPTY_STRING_ARRAY;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = exitStatus;
        }
        String[] newExitStatus = stringArray;
        if (stepBuilder != null) {
            stepBuilder.failOn(on).exitStatus(newExitStatus);
        } else if (flowBuilder != null) {
            flowBuilder.failOn(on).exitStatus(newExitStatus);
        } else if (decisionBuilder != null) {
            decisionBuilder.failOn(on).exitStatus(newExitStatus);
        }
    }

    private static void mapSingleStop(JsonNode singleStopNode, StepBuilder stepBuilder, FlowBuilder flowBuilder, DecisionBuilder decisionBuilder) {
        String[] stringArray;
        String on = JsonJobMapper.getRequiredTextValue(singleStopNode, XmlAttribute.ON, XmlElement.STOP);
        String restartFrom = singleStopNode.path(XmlAttribute.RESTART.getLocalName()).asText(null);
        String exitStatus = singleStopNode.path(XmlAttribute.EXIT_STATUS.getLocalName()).asText(null);
        if (exitStatus == null) {
            stringArray = EMPTY_STRING_ARRAY;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = exitStatus;
        }
        String[] newExitStatus = stringArray;
        if (stepBuilder != null) {
            stepBuilder.stopOn(on).restartFrom(restartFrom).exitStatus(newExitStatus);
        } else if (flowBuilder != null) {
            flowBuilder.stopOn(on).restartFrom(restartFrom).exitStatus(newExitStatus);
        } else if (decisionBuilder != null) {
            decisionBuilder.stopOn(on).restartFrom(restartFrom).exitStatus(newExitStatus);
        }
    }

    private static void mapSingleNext(JsonNode singleNextNode, StepBuilder stepBuilder, FlowBuilder flowBuilder, DecisionBuilder decisionBuilder) {
        if (singleNextNode.isObject()) {
            String on = JsonJobMapper.getRequiredTextValue(singleNextNode, XmlAttribute.ON, XmlElement.NEXT);
            String to = JsonJobMapper.getRequiredTextValue(singleNextNode, XmlAttribute.TO, XmlElement.NEXT);
            if (stepBuilder != null) {
                stepBuilder.nextOn(on).to(to);
            } else if (flowBuilder != null) {
                flowBuilder.nextOn(on).to(to);
            } else if (decisionBuilder != null) {
                decisionBuilder.nextOn(on).to(to);
            }
        }
    }

    private static void mapSingleStep(JsonNode step1Node, Consumer<Step> applyMethod) {
        StepBuilder stepBuilder = new StepBuilder(JsonJobMapper.getRequiredTextValue(step1Node, XmlAttribute.ID, XmlElement.JOB, XmlElement.STEP));
        JsonJobMapper.applyIntValue(step1Node, XmlAttribute.START_LIMIT, arg_0 -> ((StepBuilder)stepBuilder).startLimit(arg_0));
        JsonJobMapper.applyBooleanValue(step1Node, XmlAttribute.ALLOW_START_IF_COMPLETE, xva$0 -> stepBuilder.allowStartIfComplete(new boolean[]{xva$0}));
        JsonJobMapper.applyTextValue(step1Node, XmlAttribute.NEXT, arg_0 -> ((StepBuilder)stepBuilder).next(arg_0));
        stepBuilder.properties(JsonJobMapper.parseProperties(step1Node, null));
        JsonJobMapper.applyRefArtifactWithProperties(step1Node.get(XmlElement.BATCHLET.getLocalName()), (arg_0, arg_1) -> ((StepBuilder)stepBuilder).batchlet(arg_0, arg_1), XmlElement.STEP, XmlElement.BATCHLET);
        JsonJobMapper.mapListeners(step1Node.get(XmlElement.LISTENERS.getLocalName()), (arg_0, arg_1) -> ((StepBuilder)stepBuilder).listener(arg_0, arg_1));
        JsonJobMapper.mapChunk(step1Node.get(XmlElement.CHUNK.getLocalName()), stepBuilder);
        JsonJobMapper.mapPartition(step1Node.get(XmlElement.PARTITION.getLocalName()), stepBuilder);
        JsonJobMapper.mapTransitions(step1Node, stepBuilder, null, null);
        applyMethod.accept(stepBuilder.build());
    }

    private static void mapSteps(JsonNode stepNode, Consumer<Step> applyMethod) {
        if (stepNode == null) {
            return;
        }
        if (stepNode.isArray()) {
            Iterator elements = stepNode.elements();
            while (elements.hasNext()) {
                JsonJobMapper.mapSingleStep((JsonNode)elements.next(), applyMethod);
            }
        } else {
            JsonJobMapper.mapSingleStep(stepNode, applyMethod);
        }
    }

    private static void mapChunk(JsonNode chunkNode, StepBuilder stepBuilder) {
        if (chunkNode == null) {
            return;
        }
        JsonJobMapper.applyIntValue(chunkNode, XmlAttribute.RETRY_LIMIT, arg_0 -> ((StepBuilder)stepBuilder).retryLimit(arg_0));
        JsonJobMapper.applyIntValue(chunkNode, XmlAttribute.SKIP_LIMIT, arg_0 -> ((StepBuilder)stepBuilder).skipLimit(arg_0));
        JsonJobMapper.applyIntValue(chunkNode, XmlAttribute.TIME_LIMIT, x$0 -> stepBuilder.timeLimit(x$0, new TimeUnit[0]));
        JsonJobMapper.applyIntValue(chunkNode, XmlAttribute.ITEM_COUNT, arg_0 -> ((StepBuilder)stepBuilder).itemCount(arg_0));
        JsonJobMapper.applyTextValue(chunkNode, XmlAttribute.CHECKPOINT_POLICY, arg_0 -> ((StepBuilder)stepBuilder).checkpointPolicy(arg_0));
        JsonJobMapper.applyRefArtifactWithProperties(chunkNode.get(XmlElement.READER.getLocalName()), (arg_0, arg_1) -> ((StepBuilder)stepBuilder).reader(arg_0, arg_1), XmlElement.CHUNK, XmlElement.READER);
        JsonJobMapper.applyRefArtifactWithProperties(chunkNode.get(XmlElement.PROCESSOR.getLocalName()), (arg_0, arg_1) -> ((StepBuilder)stepBuilder).processor(arg_0, arg_1), XmlElement.CHUNK, XmlElement.PROCESSOR);
        JsonJobMapper.applyRefArtifactWithProperties(chunkNode.get(XmlElement.WRITER.getLocalName()), (arg_0, arg_1) -> ((StepBuilder)stepBuilder).writer(arg_0, arg_1), XmlElement.CHUNK, XmlElement.WRITER);
        JsonJobMapper.applyRefArtifactWithProperties(chunkNode.get(XmlElement.CHECKPOINT_ALGORITHM.getLocalName()), (arg_0, arg_1) -> ((StepBuilder)stepBuilder).checkpointAlgorithm(arg_0, arg_1), XmlElement.CHUNK, XmlElement.CHECKPOINT_ALGORITHM);
        JsonJobMapper.mapExceptionFilter(chunkNode.get(XmlElement.SKIPPABLE_EXCEPTION_CLASSES.getLocalName()), arg_0 -> ((StepBuilder)stepBuilder).skippableExceptionsInclude(arg_0), arg_0 -> ((StepBuilder)stepBuilder).skippableExceptionsExclude(arg_0));
        JsonJobMapper.mapExceptionFilter(chunkNode.get(XmlElement.RETRYABLE_EXCEPTION_CLASSES.getLocalName()), arg_0 -> ((StepBuilder)stepBuilder).retryableExceptionsInclude(arg_0), arg_0 -> ((StepBuilder)stepBuilder).retryableExceptionsExclude(arg_0));
        JsonJobMapper.mapExceptionFilter(chunkNode.get(XmlElement.NO_ROLLBACK_EXCEPTION_CLASSES.getLocalName()), arg_0 -> ((StepBuilder)stepBuilder).noRollbackExceptionsInclude(arg_0), arg_0 -> ((StepBuilder)stepBuilder).noRollbackExceptionsExclude(arg_0));
    }

    private static void mapExceptionFilter(JsonNode exceptionFilterNode, Consumer<List<String>> includeMethod, Consumer<List<String>> excludeMethod) {
        if (exceptionFilterNode != null) {
            JsonNode excludeNode;
            JsonNode includeNode = exceptionFilterNode.get(XmlElement.INCLUDE.getLocalName());
            if (includeNode != null) {
                List includedClassNames = includeNode.findValuesAsText(XmlAttribute.CLASS.getLocalName());
                includeMethod.accept(includedClassNames);
            }
            if ((excludeNode = exceptionFilterNode.get(XmlElement.EXCLUDE.getLocalName())) != null) {
                List excludedClassNames = excludeNode.findValuesAsText(XmlAttribute.CLASS.getLocalName());
                excludeMethod.accept(excludedClassNames);
            }
        }
    }

    private static void mapPartition(JsonNode partitionNode, StepBuilder stepBuilder) {
        if (partitionNode != null) {
            JsonJobMapper.applyRefArtifactWithProperties(partitionNode.get(XmlElement.COLLECTOR.getLocalName()), (arg_0, arg_1) -> ((StepBuilder)stepBuilder).partitionCollector(arg_0, arg_1), XmlElement.PARTITION, XmlElement.COLLECTOR);
            JsonJobMapper.applyRefArtifactWithProperties(partitionNode.get(XmlElement.REDUCER.getLocalName()), (arg_0, arg_1) -> ((StepBuilder)stepBuilder).partitionReducer(arg_0, arg_1), XmlElement.PARTITION, XmlElement.REDUCER);
            JsonJobMapper.applyRefArtifactWithProperties(partitionNode.get(XmlElement.ANALYZER.getLocalName()), (arg_0, arg_1) -> ((StepBuilder)stepBuilder).partitionAnalyzer(arg_0, arg_1), XmlElement.PARTITION, XmlElement.ANALYZER);
            JsonJobMapper.applyRefArtifactWithProperties(partitionNode.get(XmlElement.MAPPER.getLocalName()), (arg_0, arg_1) -> ((StepBuilder)stepBuilder).partitionMapper(arg_0, arg_1), XmlElement.PARTITION, XmlElement.MAPPER);
            JsonNode planNode = partitionNode.get(XmlElement.PLAN.getLocalName());
            if (planNode != null) {
                JsonNode threadsNode;
                int partitions = 0;
                int threads = 0;
                JsonNode partitionsNode = planNode.get(XmlAttribute.PARTITIONS.getLocalName());
                if (partitionsNode != null) {
                    partitions = partitionsNode.asInt();
                }
                if ((threadsNode = planNode.get(XmlAttribute.THREADS.getLocalName())) != null) {
                    threads = threadsNode.asInt();
                }
                ArrayList<Properties> partitionPropertiesList = new ArrayList<Properties>();
                JsonJobMapper.parseProperties(planNode, partitionPropertiesList);
                stepBuilder.partitionPlan(partitions, threads, partitionPropertiesList);
            }
        }
    }

    private static void mapListeners(JsonNode listenersNode, BiConsumer<String, Properties> applyMethod) {
        JsonNode listenerNode;
        if (listenersNode != null && (listenerNode = listenersNode.get(XmlElement.LISTENER.getLocalName())) != null) {
            if (listenerNode.isArray()) {
                Iterator elements = listenerNode.elements();
                while (elements.hasNext()) {
                    JsonJobMapper.applyRefArtifactWithProperties((JsonNode)elements.next(), applyMethod, XmlElement.LISTENERS, XmlElement.LISTENER);
                }
            } else {
                JsonJobMapper.applyRefArtifactWithProperties(listenerNode, applyMethod, XmlElement.LISTENERS, XmlElement.LISTENER);
            }
        }
    }

    private static void applyRefArtifactWithProperties(JsonNode artifactNode, BiConsumer<String, Properties> applyMethod, XmlElement ... parentElements) {
        if (artifactNode != null) {
            String ref = JsonJobMapper.getRequiredTextValue(artifactNode, XmlAttribute.REF, parentElements);
            Properties properties = JsonJobMapper.parseProperties(artifactNode, null);
            applyMethod.accept(ref, properties);
        }
    }

    private static void applyIntValue(JsonNode parentNode, XmlAttribute attr, Consumer<Integer> applyMethod) {
        JsonNode attrNode = parentNode.get(attr.getLocalName());
        if (attrNode != null) {
            int intValue = attrNode.intValue();
            applyMethod.accept(intValue);
        }
    }

    private static void applyBooleanValue(JsonNode parentNode, XmlAttribute attr, Consumer<Boolean> applyMethod) {
        JsonNode attrNode = parentNode.get(attr.getLocalName());
        if (attrNode != null) {
            boolean booleanValue = attrNode.booleanValue();
            applyMethod.accept(booleanValue);
        }
    }

    private static void applyTextValue(JsonNode parentNode, XmlAttribute attr, Consumer<String> applyMethod) {
        JsonNode attrNode = parentNode.get(attr.getLocalName());
        if (attrNode != null && (attr != XmlAttribute.NEXT || attrNode.isTextual())) {
            String textValue = attrNode.textValue();
            applyMethod.accept(textValue);
        }
    }

    private static Properties parseProperties(JsonNode containingNode, List<Properties> propertiesList) {
        if (containingNode == null) {
            return null;
        }
        JsonNode propertiesNode = containingNode.get(XmlElement.PROPERTIES.getLocalName());
        if (propertiesNode == null) {
            return null;
        }
        if (propertiesNode.isArray()) {
            Iterator elements = propertiesNode.elements();
            while (elements.hasNext()) {
                JsonNode next = (JsonNode)elements.next();
                Properties properties = new Properties();
                JsonJobMapper.parsePropertyEntries(next, properties);
                propertiesList.add(properties);
            }
            return null;
        }
        Properties properties = new Properties();
        JsonJobMapper.parsePropertyEntries(propertiesNode, properties);
        return properties;
    }

    private static void parsePropertyEntries(JsonNode containingNode, Properties properties) {
        JsonNode propertyNode = containingNode.get(XmlElement.PROPERTY.getLocalName());
        if (propertyNode != null) {
            if (propertyNode.isArray()) {
                Iterator elements = propertyNode.elements();
                while (elements.hasNext()) {
                    JsonNode next = (JsonNode)elements.next();
                    properties.setProperty(JsonJobMapper.getRequiredTextValue(next, XmlAttribute.NAME, XmlElement.PROPERTIES, XmlElement.PROPERTY), JsonJobMapper.getRequiredTextValue(next, XmlAttribute.VALUE, XmlElement.PROPERTIES, XmlElement.PROPERTY));
                }
            } else {
                properties.setProperty(JsonJobMapper.getRequiredTextValue(propertyNode, XmlAttribute.NAME, XmlElement.PROPERTIES, XmlElement.PROPERTY), JsonJobMapper.getRequiredTextValue(propertyNode, XmlAttribute.VALUE, XmlElement.PROPERTIES, XmlElement.PROPERTY));
            }
        }
    }

    private static String getRequiredTextValue(JsonNode node, XmlAttribute attr, XmlElement ... parents) {
        JsonNode node1 = node.get(attr.getLocalName());
        if (node1 == null) {
            String[] parentsAsStrings = (String[])Arrays.stream(parents).map(XmlElement::getLocalName).toArray(String[]::new);
            throw RestCommonsMessages.MESSAGES.expectingJsonElement(attr.getLocalName(), parentsAsStrings);
        }
        return node1.textValue();
    }
}

