/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.web.selenium;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.jbehave.web.selenium.WebDriverProvider;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;

public abstract class DelegatingWebDriverProvider
implements WebDriverProvider {
    protected ThreadLocal<WebDriver> delegate = new ThreadLocal();

    @Override
    public WebDriver get() {
        WebDriver webDriver = this.delegate.get();
        if (webDriver == null) {
            throw new DelegateWebDriverNotFound();
        }
        return webDriver;
    }

    @Override
    public void end() {
        this.delegate.get().quit();
        this.delegate.remove();
    }

    @Override
    public boolean saveScreenshotTo(String path) {
        WebDriver driver = this.get();
        if (driver instanceof TakesScreenshot) {
            File file = new File(path);
            byte[] bytes = (byte[])((TakesScreenshot)driver).getScreenshotAs(OutputType.BYTES);
            file.getParentFile().mkdirs();
            try {
                file.createNewFile();
                IOUtils.write((byte[])bytes, (OutputStream)new FileOutputStream(file));
            }
            catch (IOException e) {
                throw new RuntimeException("Can't save file", e);
            }
            return true;
        }
        return false;
    }

    public static class DelegateWebDriverNotFound
    extends RuntimeException {
        public DelegateWebDriverNotFound() {
            super("WebDriver has not been found for this thread.\nPlease verify you are using the correct WebDriverProvider, with the appropriate credentials if using remote access, e.g. to SauceLabs: -DSAUCE_USERNAME=xxxxxx -DSAUCE_ACCESS_KEY=xxx-xxxx-xxxx-xxxx-xxx ");
        }
    }
}

