/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.web.selenium;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.jbehave.web.selenium.DelegatingWebDriverProvider;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.HttpCommandExecutor;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.Response;

public class RemoteWebDriverProvider
extends DelegatingWebDriverProvider {
    private final DesiredCapabilities desiredCapabilities;
    private boolean verbose = false;

    public RemoteWebDriverProvider() {
        this(null);
    }

    protected DesiredCapabilities makeDesiredCapabilities() {
        DesiredCapabilities desiredCapabilities = DesiredCapabilities.firefox();
        desiredCapabilities.setCapability("takesScreenshot", true);
        desiredCapabilities.setVersion(this.getBrowserVersion());
        return desiredCapabilities;
    }

    protected String getBrowserVersion() {
        String bv = System.getProperty("browser.version");
        return bv == null ? "3.6." : bv;
    }

    public RemoteWebDriverProvider(DesiredCapabilities desiredCapabilities) {
        this.desiredCapabilities = desiredCapabilities == null ? this.makeDesiredCapabilities() : desiredCapabilities;
    }

    @Override
    public void initialize() {
        ScreenshootingRemoteWebDriver remoteWebDriver;
        URL url = null;
        try {
            url = this.createRemoteURL();
            remoteWebDriver = new ScreenshootingRemoteWebDriver(this.wrapCommandExecutor((CommandExecutor)new HttpCommandExecutor(url)), this.desiredCapabilities);
        }
        catch (Throwable e) {
            if (this.verbose) {
                System.err.println("*********** Remote WebDriver Initialization Failure ************");
                e.printStackTrace(System.err);
            }
            throw new UnsupportedOperationException("Connecting to remote URL '" + url + "' failed: " + e.getMessage(), e);
        }
        this.delegate.set(remoteWebDriver);
    }

    protected CommandExecutor wrapCommandExecutor(CommandExecutor commandExecutor) {
        return commandExecutor;
    }

    public URL createRemoteURL() throws MalformedURLException {
        String url = System.getProperty("REMOTE_WEBDRIVER_URL");
        if (url == null) {
            throw new UnsupportedOperationException("REMOTE_WEBDRIVER_URL property not specified");
        }
        return new URL(url);
    }

    public void useVerbosity(boolean verbose) {
        this.verbose = verbose;
    }

    public static class SauceLabsJobHasEnded
    extends WebDriverException {
        public SauceLabsJobHasEnded() {
            super("SauceLabs job has ended.  It may have timed-out previously.  Not even screen-shots, after-scenario or after-story steps are possible after this for this WebDriver instance");
        }
    }

    static class ScreenshootingRemoteWebDriver
    extends RemoteWebDriver
    implements TakesScreenshot {
        private boolean sauceJobEnded = false;

        public ScreenshootingRemoteWebDriver(CommandExecutor commandExecutor, DesiredCapabilities desiredCapabilities) {
            super(commandExecutor, (Capabilities)desiredCapabilities);
        }

        public <X> X getScreenshotAs(OutputType<X> target) throws WebDriverException {
            String base64 = this.execute("screenshot").getValue().toString();
            return (X)target.convertFromBase64Png(base64);
        }

        protected Response execute(String driverCommand, Map<String, ?> parameters) {
            if (this.sauceJobEnded) {
                throw new SauceLabsJobHasEnded();
            }
            try {
                return super.execute(driverCommand, parameters);
            }
            catch (WebDriverException e) {
                if (e.getMessage().indexOf("Job on Sauce is already complete") > -1) {
                    this.sauceJobEnded = true;
                    throw new SauceLabsJobHasEnded();
                }
                throw e;
            }
            catch (RuntimeException e) {
                throw e;
            }
        }
    }
}

