/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.web.selenium;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlashDriver
implements WebDriver {
    protected WebDriver delegate;
    protected String flashObjectId;

    public FlashDriver(WebDriver delegate, String flashObjectId) {
        this.delegate = delegate;
        this.flashObjectId = flashObjectId;
    }

    public Object call(String functionName, String ... args) {
        if (this.delegate instanceof JavascriptExecutor) {
            WebElement flashObject = this.findFlashObject(this.flashObjectId);
            String script = this.formatJavascript(functionName, args);
            return ((JavascriptExecutor)this.delegate).executeScript(script, new Object[]{flashObject});
        }
        throw new JavascriptNotSupported(this.delegate);
    }

    protected WebElement findFlashObject(String flashObjectId) {
        return this.delegate.findElement(By.id((String)flashObjectId));
    }

    protected String formatJavascript(String functionName, String ... args) {
        ArrayList<String> quotedArgs = new ArrayList<String>();
        for (String arg : args) {
            quotedArgs.add("'" + arg + "'");
        }
        return "return arguments[0]." + functionName + "(" + StringUtils.join(quotedArgs, (String)",") + ");";
    }

    public void click() {
        this.call("click", new String[0]);
    }

    public int percentLoaded() {
        return Integer.parseInt(this.call("PercentLoaded", new String[0]).toString());
    }

    public void get(String s) {
        this.delegate.get(s);
    }

    public String getCurrentUrl() {
        return this.delegate.getCurrentUrl();
    }

    public String getTitle() {
        return this.delegate.getTitle();
    }

    public List<WebElement> findElements(By by) {
        return this.delegate.findElements(by);
    }

    public WebElement findElement(By by) {
        return this.delegate.findElement(by);
    }

    public String getPageSource() {
        return this.delegate.getPageSource();
    }

    public void close() {
        this.delegate.close();
    }

    public void quit() {
        this.delegate.quit();
    }

    public Set<String> getWindowHandles() {
        return this.delegate.getWindowHandles();
    }

    public String getWindowHandle() {
        return this.delegate.getWindowHandle();
    }

    public WebDriver.TargetLocator switchTo() {
        return this.delegate.switchTo();
    }

    public WebDriver.Navigation navigate() {
        return this.delegate.navigate();
    }

    public WebDriver.Options manage() {
        return this.delegate.manage();
    }

    public static class JavascriptNotSupported
    extends RuntimeException {
        public JavascriptNotSupported(WebDriver delegate) {
            super("Javascript not supported by WebDriver " + delegate);
        }
    }
}

