/*
 * Decompiled with CFR 0.152.
 */
package javolution.lang;

import java.util.Random;

public final class MathLib {
    private static final Random RANDOM = new Random();
    private static final byte[] BIT_LENGTH = new byte[]{0, 1, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8};
    private static final long MASK_63 = Long.MAX_VALUE;
    private static final long MASK_32 = 0xFFFFFFFFL;
    private static final int[] POW5_INT = new int[]{1, 5, 25, 125, 625, 3125, 15625, 78125, 390625, 1953125, 9765625, 48828125, 244140625, 1220703125};
    private static final double LOG2_DIV_LOG10 = 0.3010299956639812;
    public static final double E = Math.E;
    public static final double PI = Math.PI;
    public static final double HALF_PI = 1.5707963267948966;
    public static final double TWO_PI = Math.PI * 2;
    public static final double FOUR_PI = Math.PI * 4;
    public static final double PI_SQUARE = Math.PI * Math.PI;
    public static final double LOG2 = 0.6931471805599453;
    public static final double LOG10 = 2.302585092994046;
    public static final double SQRT2 = 1.4142135623730951;
    public static final double NaN = Double.NaN;
    public static final double Infinity = Double.POSITIVE_INFINITY;
    private static double INV_LOG10 = 0.4342944819032518;
    private static final double NORMALIZATION_FACTOR = 4.656612873077393E-10;
    static final double[] atanhi = new double[]{0.4636476090008061, 0.7853981633974483, 0.982793723247329, 1.5707963267948966};
    static final double[] atanlo = new double[]{2.2698777452961687E-17, 3.061616997868383E-17, 1.3903311031230998E-17, 6.123233995736766E-17};
    static final double[] aT = new double[]{0.3333333333333293, -0.19999999999876483, 0.14285714272503466, -0.11111110405462356, 0.09090887133436507, -0.0769187620504483, 0.06661073137387531, -0.058335701337905735, 0.049768779946159324, -0.036531572744216916, 0.016285820115365782};
    static final double one = 1.0;
    static final double huge = 1.0E300;
    static final double ln2_hi = 0.6931471803691238;
    static final double ln2_lo = 1.9082149292705877E-10;
    static final double two54 = 1.8014398509481984E16;
    static final double Lg1 = 0.6666666666666735;
    static final double Lg2 = 0.3999999999940942;
    static final double Lg3 = 0.2857142874366239;
    static final double Lg4 = 0.22222198432149784;
    static final double Lg5 = 0.1818357216161805;
    static final double Lg6 = 0.15313837699209373;
    static final double Lg7 = 0.14798198605116586;
    static final double zero = 0.0;
    static final double[] halF = new double[]{0.5, -0.5};
    static final double twom1000 = 9.332636185032189E-302;
    static final double o_threshold = 709.782712893384;
    static final double u_threshold = -745.1332191019411;
    static final double[] ln2HI = new double[]{0.6931471803691238, -0.6931471803691238};
    static final double[] ln2LO = new double[]{1.9082149292705877E-10, -1.9082149292705877E-10};
    static final double invln2 = 1.4426950408889634;
    static final double P1 = 0.16666666666666602;
    static final double P2 = -0.0027777777777015593;
    static final double P3 = 6.613756321437934E-5;
    static final double P4 = -1.6533902205465252E-6;
    static final double P5 = 4.1381367970572385E-8;

    private MathLib() {
    }

    public static int random(int n, int n2) {
        int n3 = RANDOM.nextInt();
        if (n3 >= n && n3 <= n2) {
            return n3;
        }
        if ((n3 -= Integer.MIN_VALUE) >= n && n3 <= n2) {
            return n3;
        }
        int n4 = 1 + n2 - n;
        if (n4 <= 0) {
            throw new Error("Interval error");
        }
        return MathLib.abs(n3 % n4) + n;
    }

    public static long random(long l, long l2) {
        long l3 = RANDOM.nextLong();
        if (l3 >= l && l3 <= l2) {
            return l3;
        }
        if ((l3 += Long.MIN_VALUE) >= l && l3 <= l2) {
            return l3;
        }
        long l4 = 1L + l2 - l;
        if (l4 <= 0L) {
            throw new Error("Interval error");
        }
        return MathLib.abs(l3 % l4) + l;
    }

    public static float random(float f, float f2) {
        return (float)MathLib.random((double)f, (double)f2);
    }

    public static double random(double d, double d2) {
        double d3 = RANDOM.nextDouble();
        return d + d3 * d2 - d3 * d;
    }

    public static int bitLength(int n) {
        if (n < 0) {
            ++n;
            n = -n;
        }
        return n < 65536 ? (n < 256 ? BIT_LENGTH[n] : BIT_LENGTH[n >>> 8] + 8) : (n < 0x1000000 ? BIT_LENGTH[n >>> 16] + 16 : BIT_LENGTH[n >>> 24] + 24);
    }

    public static int bitLength(long l) {
        int n = (int)(l >> 32);
        if (n > 0) {
            return n < 65536 ? (n < 256 ? BIT_LENGTH[n] + 32 : BIT_LENGTH[n >>> 8] + 40) : (n < 0x1000000 ? BIT_LENGTH[n >>> 16] + 48 : BIT_LENGTH[n >>> 24] + 56);
        }
        if (n < 0) {
            return MathLib.bitLength(-(++l));
        }
        n = (int)l;
        return n < 0 ? 32 : (n < 65536 ? (n < 256 ? BIT_LENGTH[n] : BIT_LENGTH[n >>> 8] + 8) : (n < 0x1000000 ? BIT_LENGTH[n >>> 16] + 16 : BIT_LENGTH[n >>> 24] + 24));
    }

    public static int digitLength(int n) {
        if (n < 0) {
            ++n;
            n = -n;
        }
        return n >= 100000 ? (n >= 10000000 ? (n >= 1000000000 ? 10 : (n >= 100000000 ? 9 : 8)) : (n >= 1000000 ? 7 : 6)) : (n >= 100 ? (n >= 10000 ? 5 : (n >= 1000 ? 4 : 3)) : (n >= 10 ? 2 : (n >= 1 ? 1 : 0)));
    }

    public static int digitLength(long l) {
        if (l < 0L) {
            ++l;
            l = -l;
        }
        if (l <= Integer.MAX_VALUE) {
            int n = (int)l;
            return n >= 100000 ? (n >= 10000000 ? (n >= 1000000000 ? 10 : (n >= 100000000 ? 9 : 8)) : (n >= 1000000 ? 7 : 6)) : (n >= 100 ? (n >= 10000 ? 5 : (n >= 1000 ? 4 : 3)) : (n >= 10 ? 2 : (n >= 1 ? 1 : 0)));
        }
        return l >= 100000000000000L ? (l >= 10000000000000000L ? (l >= 1000000000000000000L ? 19 : (l >= 100000000000000000L ? 18 : 17)) : (l >= 1000000000000000L ? 16 : 15)) : (l >= 100000000000L ? (l >= 10000000000000L ? 14 : (l >= 1000000000000L ? 13 : 12)) : (l >= 10000000000L ? 11 : 10));
    }

    public static double toDoublePow2(long l, int n) {
        long l2;
        if (l == 0L) {
            return 0.0;
        }
        if (l == Long.MIN_VALUE) {
            return MathLib.toDoublePow2(-4611686018427387904L, n + 1);
        }
        if (l < 0L) {
            return -MathLib.toDoublePow2(-l, n);
        }
        int n2 = MathLib.bitLength(l);
        int n3 = n2 - 53;
        long l3 = 1075L + (long)n + (long)n3;
        if (l3 >= 2047L) {
            return Double.POSITIVE_INFINITY;
        }
        if (l3 <= 0L) {
            if (l3 <= -54L) {
                return 0.0;
            }
            return MathLib.toDoublePow2(l, n + 54) / 1.8014398509481984E16;
        }
        long l4 = l2 = n3 > 0 ? (l >> n3) + (l >> n3 - 1 & 1L) : l << -n3;
        if (l2 >> 52 != 1L && ++l3 >= 2047L) {
            return Double.POSITIVE_INFINITY;
        }
        l2 &= 0xFFFFFFFFFFFFFL;
        return Double.longBitsToDouble(l2 |= l3 << 52);
    }

    public static double toDoublePow10(long l, int n) {
        if (l == 0L) {
            return 0.0;
        }
        if (l == Long.MIN_VALUE) {
            return MathLib.toDoublePow10(-922337203685477580L, n + 1);
        }
        if (l < 0L) {
            return -MathLib.toDoublePow10(-l, n);
        }
        if (n >= 0) {
            int n2;
            if (n > 308) {
                return Double.POSITIVE_INFINITY;
            }
            long l2 = 0L;
            long l3 = 0L;
            long l4 = l & 0xFFFFFFFFL;
            long l5 = l >>> 32;
            int n3 = 0;
            while (n != 0) {
                n2 = n >= POW5_INT.length ? POW5_INT.length - 1 : n;
                int n4 = POW5_INT[n2];
                if ((int)l2 != 0) {
                    l2 *= (long)n4;
                }
                if ((int)l3 != 0) {
                    l3 *= (long)n4;
                }
                l4 *= (long)n4;
                l5 *= (long)n4;
                l3 &= 0xFFFFFFFFL;
                l4 &= 0xFFFFFFFFL;
                n3 += n2;
                n -= n2;
                long l6 = (l5 += (l4 += (l3 += (l2 &= 0xFFFFFFFFL) >>> 32) >>> 32) >>> 32) >>> 32;
                if (l6 == 0L) continue;
                l2 = l3;
                l3 = l4;
                l4 = l5 & 0xFFFFFFFFL;
                l5 = l6;
                n3 += 32;
            }
            n2 = 31 - MathLib.bitLength(l5);
            long l7 = n2 < 0 ? l5 << 31 | l4 >>> 1 : (l5 << 32 | l4) << n2 | l3 >>> 32 - n2;
            return MathLib.toDoublePow2(l7, n3 -= n2);
        }
        if (n < -344) {
            return 0.0;
        }
        long l8 = l;
        long l9 = 0L;
        int n5 = 0;
        while (true) {
            int n6 = 63 - MathLib.bitLength(l8);
            l8 <<= n6;
            l8 |= l9 >>> 63 - n6;
            l9 = l9 << n6 & Long.MAX_VALUE;
            n5 -= n6;
            if (n == 0) break;
            int n7 = -n >= POW5_INT.length ? POW5_INT.length - 1 : -n;
            int n8 = POW5_INT[n7];
            long l10 = l8 >>> 32;
            long l11 = l10 / (long)n8;
            long l12 = l10 - l11 * (long)n8;
            long l13 = l12 << 32 | l8 & 0xFFFFFFFFL;
            long l14 = l13 / (long)n8;
            l12 = l13 - l14 * (long)n8;
            l8 = l11 << 32 | l14;
            l10 = l12 << 31 | l9 >>> 32;
            l11 = l10 / (long)n8;
            l12 = l10 - l11 * (long)n8;
            l13 = l12 << 32 | l9 & 0xFFFFFFFFL;
            l14 = l13 / (long)n8;
            l9 = l11 << 32 | l14;
            n += n7;
            n5 -= n7;
        }
        return MathLib.toDoublePow2(l8, n5);
    }

    public static long toLongPow2(double d, int n) {
        long l = Double.doubleToRawLongBits(d);
        boolean bl = l >> 63 != 0L;
        int n2 = (int)(l >> 52) & 0x7FF;
        long l2 = l & 0xFFFFFFFFFFFFFL;
        if (n2 == 2047) {
            throw new ArithmeticException("Cannot convert to long (Infinity or NaN)");
        }
        if (n2 == 0) {
            if (l2 == 0L) {
                return 0L;
            }
            return MathLib.toLongPow2(d * 1.8014398509481984E16, n - 54);
        }
        l2 |= 0x10000000000000L;
        long l3 = (long)n2 - 1023L - 52L + (long)n;
        if (l3 <= -64L) {
            return 0L;
        }
        if (l3 >= 11L) {
            throw new ArithmeticException("Cannot convert to long (overflow)");
        }
        l2 = l3 >= 0L ? l2 << (int)l3 : (l2 >> (int)(-l3)) + (l2 >> (int)(-(l3 + 1L)) & 1L);
        return bl ? -l2 : l2;
    }

    public static long toLongPow10(double d, int n) {
        long l = Double.doubleToRawLongBits(d);
        boolean bl = l >> 63 != 0L;
        int n2 = (int)(l >> 52) & 0x7FF;
        long l2 = l & 0xFFFFFFFFFFFFFL;
        if (n2 == 2047) {
            throw new ArithmeticException("Cannot convert to long (Infinity or NaN)");
        }
        if (n2 == 0) {
            if (l2 == 0L) {
                return 0L;
            }
            return MathLib.toLongPow10(d * 1.0E16, n - 16);
        }
        l2 |= 0x10000000000000L;
        int n3 = n2 - 1023 - 52;
        if (n >= 0) {
            int n4;
            long l3 = 0L;
            long l4 = 0L;
            long l5 = l2 & 0xFFFFFFFFL;
            long l6 = l2 >>> 32;
            while (n != 0) {
                n4 = n >= POW5_INT.length ? POW5_INT.length - 1 : n;
                int n5 = POW5_INT[n4];
                if ((int)l3 != 0) {
                    l3 *= (long)n5;
                }
                if ((int)l4 != 0) {
                    l4 *= (long)n5;
                }
                l5 *= (long)n5;
                l6 *= (long)n5;
                l4 &= 0xFFFFFFFFL;
                l5 &= 0xFFFFFFFFL;
                n3 += n4;
                n -= n4;
                long l7 = (l6 += (l5 += (l4 += (l3 &= 0xFFFFFFFFL) >>> 32) >>> 32) >>> 32) >>> 32;
                if (l7 == 0L) continue;
                l3 = l4;
                l4 = l5;
                l5 = l6 & 0xFFFFFFFFL;
                l6 = l7;
                n3 += 32;
            }
            n4 = 31 - MathLib.bitLength(l6);
            n3 -= n4;
            l2 = n4 < 0 ? l6 << 31 | l5 >>> 1 : (l6 << 32 | l5) << n4 | l4 >>> 32 - n4;
        } else {
            long l8 = l2;
            long l9 = 0L;
            while (true) {
                int n6 = 63 - MathLib.bitLength(l8);
                l8 <<= n6;
                l8 |= l9 >>> 63 - n6;
                l9 = l9 << n6 & Long.MAX_VALUE;
                n3 -= n6;
                if (n == 0) break;
                int n7 = -n >= POW5_INT.length ? POW5_INT.length - 1 : -n;
                int n8 = POW5_INT[n7];
                long l10 = l8 >>> 32;
                long l11 = l10 / (long)n8;
                long l12 = l10 - l11 * (long)n8;
                long l13 = l12 << 32 | l8 & 0xFFFFFFFFL;
                long l14 = l13 / (long)n8;
                l12 = l13 - l14 * (long)n8;
                l8 = l11 << 32 | l14;
                l10 = l12 << 31 | l9 >>> 32;
                l11 = l10 / (long)n8;
                l12 = l10 - l11 * (long)n8;
                l13 = l12 << 32 | l9 & 0xFFFFFFFFL;
                l14 = l13 / (long)n8;
                l9 = l11 << 32 | l14;
                n += n7;
                n3 -= n7;
            }
            l2 = l8;
        }
        if (n3 > 0) {
            throw new ArithmeticException("Overflow");
        }
        if (n3 < -63) {
            return 0L;
        }
        l2 = (l2 >> -n3) + (l2 >> -(n3 + 1) & 1L);
        return bl ? -l2 : l2;
    }

    public static int floorLog2(double d) {
        if (d <= 0.0) {
            throw new ArithmeticException("Negative number or zero");
        }
        long l = Double.doubleToRawLongBits(d);
        int n = (int)(l >> 52) & 0x7FF;
        if (n == 2047) {
            throw new ArithmeticException("Infinity or NaN");
        }
        if (n == 0) {
            return MathLib.floorLog2(d * 1.8014398509481984E16) - 54;
        }
        return n - 1023;
    }

    public static int floorLog10(double d) {
        int n = (int)(0.3010299956639812 * (double)MathLib.floorLog2(d));
        double d2 = MathLib.toDoublePow10(1L, n);
        if (d2 <= d && d2 * 10.0 > d) {
            return n;
        }
        if (d2 > d) {
            return n - 1;
        }
        return n + 1;
    }

    public static double toRadians(double d) {
        return d * (Math.PI / 180);
    }

    public static double toDegrees(double d) {
        return d * 57.29577951308232;
    }

    public static double sqrt(double d) {
        return Math.sqrt(d);
    }

    public static double rem(double d, double d2) {
        double d3 = d / d2;
        if (MathLib.abs(d3) <= 9.223372036854776E18) {
            return d - (double)MathLib.round(d3) * d2;
        }
        return Double.NaN;
    }

    public static double ceil(double d) {
        return Math.ceil(d);
    }

    public static double floor(double d) {
        return Math.floor(d);
    }

    public static double sin(double d) {
        return Math.sin(d);
    }

    public static double cos(double d) {
        return Math.cos(d);
    }

    public static double tan(double d) {
        return Math.tan(d);
    }

    public static double asin(double d) {
        if (d < -1.0 || d > 1.0) {
            return Double.NaN;
        }
        if (d == -1.0) {
            return -1.5707963267948966;
        }
        if (d == 1.0) {
            return 1.5707963267948966;
        }
        return MathLib.atan(d / MathLib.sqrt(1.0 - d * d));
    }

    public static double acos(double d) {
        return 1.5707963267948966 - MathLib.asin(d);
    }

    public static double atan(double d) {
        return MathLib._atan(d);
    }

    public static double atan2(double d, double d2) {
        if (MathLib.abs(d2) > 1.0E-128) {
            double d3 = MathLib.atan(MathLib.abs(d) / MathLib.abs(d2));
            if (d2 < 0.0) {
                d3 = Math.PI - d3;
            }
            if (d < 0.0) {
                d3 = Math.PI * 2 - d3;
            }
            return d3;
        }
        if (d > 1.0E-128) {
            return 1.5707963267948966;
        }
        if (d < -1.0E-128) {
            return 4.71238898038469;
        }
        return 0.0;
    }

    public static double sinh(double d) {
        return (MathLib.exp(d) - MathLib.exp(-d)) * 0.5;
    }

    public static double cosh(double d) {
        return (MathLib.exp(d) + MathLib.exp(-d)) * 0.5;
    }

    public static double tanh(double d) {
        return (MathLib.exp(2.0 * d) - 1.0) / (MathLib.exp(2.0 * d) + 1.0);
    }

    public static double exp(double d) {
        return MathLib._ieee754_exp(d);
    }

    public static double log(double d) {
        return MathLib._ieee754_log(d);
    }

    public static double log10(double d) {
        return MathLib.log(d) * INV_LOG10;
    }

    public static double pow(double d, double d2) {
        return MathLib.exp(d2 * MathLib.log(d));
    }

    public static int round(float f) {
        return (int)MathLib.floor(f + 0.5f);
    }

    public static long round(double d) {
        return (long)MathLib.floor(d + 0.5);
    }

    public static double random() {
        return (double)MathLib.random(0, Integer.MAX_VALUE) * 4.656612873077393E-10;
    }

    public static int abs(int n) {
        return n < 0 ? -n : n;
    }

    public static long abs(long l) {
        return l < 0L ? -l : l;
    }

    public static float abs(float f) {
        return f < 0.0f ? -f : f;
    }

    public static double abs(double d) {
        return d < 0.0 ? -d : d;
    }

    public static int max(int n, int n2) {
        return n >= n2 ? n : n2;
    }

    public static long max(long l, long l2) {
        return l >= l2 ? l : l2;
    }

    public static float max(float f, float f2) {
        return f >= f2 ? f : f2;
    }

    public static double max(double d, double d2) {
        return d >= d2 ? d : d2;
    }

    public static int min(int n, int n2) {
        return n < n2 ? n : n2;
    }

    public static long min(long l, long l2) {
        return l < l2 ? l : l2;
    }

    public static float min(float f, float f2) {
        return f < f2 ? f : f2;
    }

    public static double min(double d, double d2) {
        return d < d2 ? d : d2;
    }

    static double _atan(double d) {
        int n;
        long l = Double.doubleToLongBits(d);
        int n2 = (int)(l >> 32);
        int n3 = (int)l;
        int n4 = n2;
        int n5 = n4 & Integer.MAX_VALUE;
        if (n5 >= 0x44100000) {
            if (n5 > 0x7FF00000 || n5 == 0x7FF00000 && n3 != 0) {
                return d + d;
            }
            if (n4 > 0) {
                return atanhi[3] + atanlo[3];
            }
            return -atanhi[3] - atanlo[3];
        }
        if (n5 < 1071382528) {
            if (n5 < 1042284544 && 1.0E300 + d > 1.0) {
                return d;
            }
            n = -1;
        } else {
            d = MathLib.abs(d);
            if (n5 < 0x3FF30000) {
                if (n5 < 1072037888) {
                    n = 0;
                    d = (2.0 * d - 1.0) / (2.0 + d);
                } else {
                    n = 1;
                    d = (d - 1.0) / (d + 1.0);
                }
            } else if (n5 < 1073971200) {
                n = 2;
                d = (d - 1.5) / (1.0 + 1.5 * d);
            } else {
                n = 3;
                d = -1.0 / d;
            }
        }
        double d2 = d * d;
        double d3 = d2 * d2;
        double d4 = d2 * (aT[0] + d3 * (aT[2] + d3 * (aT[4] + d3 * (aT[6] + d3 * (aT[8] + d3 * aT[10])))));
        double d5 = d3 * (aT[1] + d3 * (aT[3] + d3 * (aT[5] + d3 * (aT[7] + d3 * aT[9]))));
        if (n < 0) {
            return d - d * (d4 + d5);
        }
        d2 = atanhi[n] - (d * (d4 + d5) - atanlo[n] - d);
        return n4 < 0 ? -d2 : d2;
    }

    static double _ieee754_log(double d) {
        long l = Double.doubleToLongBits(d);
        int n = (int)(l >> 32);
        int n2 = (int)l;
        int n3 = 0;
        if (n < 0x100000) {
            if ((n & Integer.MAX_VALUE | n2) == 0) {
                return Double.NEGATIVE_INFINITY;
            }
            if (n < 0) {
                return (d - d) / 0.0;
            }
            n3 -= 54;
            l = Double.doubleToLongBits(d *= 1.8014398509481984E16);
            n = (int)(l >> 32);
        }
        if (n >= 0x7FF00000) {
            return d + d;
        }
        n3 += (n >> 20) - 1023;
        int n4 = (n &= 0xFFFFF) + 614244 & 0x100000;
        l = Double.doubleToLongBits(d);
        int n5 = n | n4 ^ 0x3FF00000;
        l = ((long)n5 & 0xFFFFFFFFL) << 32 | l & 0xFFFFFFFFL;
        d = Double.longBitsToDouble(l);
        n3 += n4 >> 20;
        double d2 = d - 1.0;
        if ((0xFFFFF & 2 + n) < 3) {
            if (d2 == 0.0) {
                if (n3 == 0) {
                    return 0.0;
                }
                double d3 = n3;
                return d3 * 0.6931471803691238 + d3 * 1.9082149292705877E-10;
            }
            double d4 = d2 * d2 * (0.5 - 0.3333333333333333 * d2);
            if (n3 == 0) {
                return d2 - d4;
            }
            double d5 = n3;
            return d5 * 0.6931471803691238 - (d4 - d5 * 1.9082149292705877E-10 - d2);
        }
        double d6 = d2 / (2.0 + d2);
        double d7 = n3;
        double d8 = d6 * d6;
        n4 = n - 398458;
        double d9 = d8 * d8;
        int n6 = 440401 - n;
        double d10 = d9 * (0.3999999999940942 + d9 * (0.22222198432149784 + d9 * 0.15313837699209373));
        double d11 = d8 * (0.6666666666666735 + d9 * (0.2857142874366239 + d9 * (0.1818357216161805 + d9 * 0.14798198605116586)));
        double d12 = d11 + d10;
        if ((n4 |= n6) > 0) {
            double d13 = 0.5 * d2 * d2;
            if (n3 == 0) {
                return d2 - (d13 - d6 * (d13 + d12));
            }
            return d7 * 0.6931471803691238 - (d13 - (d6 * (d13 + d12) + d7 * 1.9082149292705877E-10) - d2);
        }
        if (n3 == 0) {
            return d2 - d6 * (d2 - d12);
        }
        return d7 * 0.6931471803691238 - (d6 * (d2 - d12) - d7 * 1.9082149292705877E-10 - d2);
    }

    static double _ieee754_exp(double d) {
        double d2;
        double d3 = 0.0;
        double d4 = 0.0;
        int n = 0;
        long l = Double.doubleToLongBits(d);
        int n2 = (int)(l >> 32);
        int n3 = (int)l;
        int n4 = n2;
        int n5 = n4 >> 31 & 1;
        if ((n4 &= Integer.MAX_VALUE) >= 1082535490) {
            if (n4 >= 0x7FF00000) {
                if ((n4 & 0xFFFFF | n3) != 0) {
                    return d + d;
                }
                return n5 == 0 ? d : 0.0;
            }
            if (d > 709.782712893384) {
                return Double.POSITIVE_INFINITY;
            }
            if (d < -745.1332191019411) {
                return 0.0;
            }
        }
        if (n4 > 1071001154) {
            if (n4 < 1072734898) {
                d3 = d - ln2HI[n5];
                d4 = ln2LO[n5];
                n = 1 - n5 - n5;
            } else {
                n = (int)(1.4426950408889634 * d + halF[n5]);
                d2 = n;
                d3 = d - d2 * ln2HI[0];
                d4 = d2 * ln2LO[0];
            }
            d = d3 - d4;
        } else if (n4 < 0x3E300000) {
            if (1.0E300 + d > 1.0) {
                return 1.0 + d;
            }
        } else {
            n = 0;
        }
        d2 = d * d;
        double d5 = d - d2 * (0.16666666666666602 + d2 * (-0.0027777777777015593 + d2 * (6.613756321437934E-5 + d2 * (-1.6533902205465252E-6 + d2 * 4.1381367970572385E-8))));
        if (n == 0) {
            return 1.0 - (d * d5 / (d5 - 2.0) - d);
        }
        double d6 = 1.0 - (d4 - d * d5 / (2.0 - d5) - d3);
        long l2 = Double.doubleToLongBits(d6);
        int n6 = (int)(l2 >> 32);
        if (n >= -1021) {
            l2 = ((long)(n6 += n << 20) & 0xFFFFFFFFL) << 32 | l2 & 0xFFFFFFFFL;
            d6 = Double.longBitsToDouble(l2);
            return d6;
        }
        l2 = ((long)(n6 += n + 1000 << 20) & 0xFFFFFFFFL) << 32 | l2 & 0xFFFFFFFFL;
        d6 = Double.longBitsToDouble(l2);
        return d6 * 9.332636185032189E-302;
    }
}

