/*
 * Decompiled with CFR 0.152.
 */
package javolution.context;

import javolution.Javolution;
import javolution.JavolutionError;
import javolution.context.ObjectFactory;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ObjectPool<T> {
    protected static final XMLFormat<ObjectPool> XML = new XMLFormat(Javolution.j2meGetClass("javolution.context.ObjectPool")){

        public void read(XMLFormat.InputElement inputElement, Object object) throws XMLStreamException {
            ObjectPool objectPool = (ObjectPool)object;
            int n = inputElement.getAttribute("size", 0);
            objectPool.setSize(n);
        }

        public void write(Object object, XMLFormat.OutputElement outputElement) throws XMLStreamException {
            ObjectPool objectPool = (ObjectPool)object;
            outputElement.setAttribute("factory", objectPool.getFactory().getClass().toString());
            outputElement.setAttribute("size", objectPool.getSize());
        }
    };
    Thread _user;
    boolean _inUse;

    protected ObjectPool() {
    }

    public final Thread getUser() {
        return this._user;
    }

    public abstract ObjectFactory<T> getFactory();

    public final boolean isLocal() {
        if (this._user == Thread.currentThread()) {
            return true;
        }
        if (!this._inUse) {
            throw new JavolutionError("Access to inner pool or unused pool detected");
        }
        if (this._user == null) {
            return false;
        }
        throw new JavolutionError("Concurrent access to local pool detected");
    }

    public final boolean inUse() {
        return this._inUse;
    }

    public abstract int getSize();

    public abstract void setSize(int var1);

    public abstract T next();

    public abstract void recycle(T var1);

    protected abstract void recycleAll();

    protected abstract void clearAll();
}

