/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.spring.webmvc;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.javasimon.Manager;
import org.javasimon.SimonManager;
import org.javasimon.Split;
import org.javasimon.source.StopwatchSource;
import org.javasimon.spring.webmvc.HandlerLocation;
import org.javasimon.spring.webmvc.HandlerStep;
import org.javasimon.spring.webmvc.HandlerStopwatchSource;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MonitoringHandlerInterceptor
implements HandlerInterceptor {
    private final ThreadLocal<HandlerLocation> threadLocation = new ThreadLocal();
    private StopwatchSource<HandlerLocation> stopwatchSource;

    public MonitoringHandlerInterceptor(StopwatchSource<HandlerLocation> stopwatchSource) {
        this.stopwatchSource = stopwatchSource;
    }

    public MonitoringHandlerInterceptor(Manager manager) {
        this.stopwatchSource = new HandlerStopwatchSource(manager);
    }

    public MonitoringHandlerInterceptor() {
        this.stopwatchSource = new HandlerStopwatchSource(SimonManager.manager());
    }

    protected final Split startStopwatch(HandlerLocation location) {
        Split split = this.stopwatchSource.start((Object)location);
        location.setSplit(split);
        return split;
    }

    protected final Split stopStopwatch() {
        HandlerLocation location = this.threadLocation.get();
        Split split = null;
        if (location != null) {
            split = location.getSplit();
            split.stop();
            location.setSplit(null);
        }
        return split;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        HandlerLocation location = new HandlerLocation(request, handler, HandlerStep.CONTROLLER);
        this.threadLocation.set(location);
        this.startStopwatch(location);
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) {
        this.stopStopwatch();
        HandlerLocation location = this.threadLocation.get();
        location.setStep(HandlerStep.VIEW);
        this.startStopwatch(location);
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        this.stopStopwatch();
        this.threadLocation.remove();
    }
}

