/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.convert.imf;

import java.io.InputStream;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Comparator;
import java.util.Currency;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.money.CurrencyContext;
import javax.money.CurrencyContextBuilder;
import javax.money.CurrencyUnit;
import javax.money.Monetary;
import javax.money.MonetaryException;
import javax.money.NumberValue;
import javax.money.convert.ConversionContext;
import javax.money.convert.ConversionQuery;
import javax.money.convert.ExchangeRate;
import javax.money.convert.ProviderContext;
import org.javamoney.moneta.CurrencyUnitBuilder;
import org.javamoney.moneta.convert.ExchangeRateBuilder;
import org.javamoney.moneta.convert.imf.IMFRateProvider;
import org.javamoney.moneta.convert.imf.IMFRateReadingHandler;
import org.javamoney.moneta.spi.AbstractRateProvider;
import org.javamoney.moneta.spi.loader.LoaderService;

abstract class IMFAbstractRateProvider
extends AbstractRateProvider
implements LoaderService.Listener {
    private static final Logger LOG = Logger.getLogger(IMFAbstractRateProvider.class.getName());
    static final Comparator<ExchangeRate> COMPARATOR_EXCHANGE_BY_LOCAL_DATE = Comparator.comparing(c -> (LocalDate)c.getContext().get(LocalDate.class));
    static final String DEFAULT_USER_AGENT = "Chrome/51.0.2704.103";
    protected static final Map<String, CurrencyUnit> CURRENCIES_BY_NAME = new HashMap<String, CurrencyUnit>();
    protected static final CurrencyUnit SDR = CurrencyUnitBuilder.of((String)"SDR", (CurrencyContext)CurrencyContextBuilder.of((String)IMFRateProvider.class.getSimpleName()).build()).setDefaultFractionDigits(3).build(true);
    protected Map<CurrencyUnit, List<ExchangeRate>> currencyToSdr = new HashMap<CurrencyUnit, List<ExchangeRate>>();
    protected Map<CurrencyUnit, List<ExchangeRate>> sdrToCurrency = new HashMap<CurrencyUnit, List<ExchangeRate>>();
    protected volatile String loadState;
    protected volatile CountDownLatch loadLock = new CountDownLatch(1);
    protected final IMFRateReadingHandler handler;
    private final ProviderContext context;

    public IMFAbstractRateProvider(ProviderContext providerContext) {
        super(providerContext);
        this.context = providerContext;
        this.handler = new IMFRateReadingHandler(CURRENCIES_BY_NAME, this.context);
    }

    public void newDataLoaded(String resourceId, InputStream is) {
        try {
            int oldSize = this.sdrToCurrency.size();
            IMFRateReadingHandler.RateIMFResult result = this.handler.read(is);
            this.sdrToCurrency = result.getSdrToCurrency();
            this.currencyToSdr = result.getCurrencyToSdr();
            int newSize = this.sdrToCurrency.size();
            this.loadState = "Loaded " + resourceId + " exchange rates for days:" + (newSize - oldSize);
            LOG.config(this.loadState);
            this.loadLock.countDown();
        }
        catch (Exception e) {
            this.loadState = "Last Error during data load: " + e.getMessage();
            throw new IllegalArgumentException("Failed to load IMF data provided.", e);
        }
    }

    public ExchangeRate getExchangeRate(ConversionQuery conversionQuery) {
        try {
            if (this.loadLock.await(30L, TimeUnit.SECONDS)) {
                if (this.currencyToSdr.isEmpty()) {
                    return null;
                }
                if (!this.isAvailable(conversionQuery)) {
                    return null;
                }
                CurrencyUnit base = conversionQuery.getBaseCurrency();
                CurrencyUnit term = conversionQuery.getCurrency();
                LocalDate[] dates = this.getQueryDates(conversionQuery);
                ExchangeRate rate1 = this.getExchangeRate(this.currencyToSdr.get(base), dates);
                ExchangeRate rate2 = this.getExchangeRate(this.sdrToCurrency.get(term), dates);
                if (base.equals(SDR)) {
                    return rate2;
                }
                if (term.equals(SDR)) {
                    return rate1;
                }
                if (Objects.isNull(rate1) || Objects.isNull(rate2)) {
                    return null;
                }
                ConversionContext context = this.getExchangeContext("imf.digit.fraction");
                ExchangeRateBuilder builder = new ExchangeRateBuilder(context);
                builder.setBase(base);
                builder.setTerm(term);
                builder.setFactor(IMFAbstractRateProvider.multiply((NumberValue)rate1.getFactor(), (NumberValue)rate2.getFactor()));
                builder.setRateChain(new ExchangeRate[]{rate1, rate2});
                return builder.build();
            }
            this.loadLock.countDown();
            throw new MonetaryException("Failed to load currency conversion data: " + this.loadState);
        }
        catch (InterruptedException e) {
            throw new MonetaryException("Failed to load currency conversion data: Load task has been interrupted.", (Throwable)e);
        }
    }

    private ExchangeRate getExchangeRate(List<ExchangeRate> rates, LocalDate[] dates) {
        if (Objects.isNull(rates)) {
            return null;
        }
        if (Objects.isNull(dates)) {
            return rates.stream().max(COMPARATOR_EXCHANGE_BY_LOCAL_DATE).orElseThrow(() -> new MonetaryException("There is not more recent exchange rate to  rate on IMFRateProvider."));
        }
        for (LocalDate localDate : dates) {
            Predicate<ExchangeRate> filter = rate -> ((LocalDate)rate.getContext().get(LocalDate.class)).equals(localDate);
            Optional<ExchangeRate> exchangeRateOptional = rates.stream().filter(filter).findFirst();
            if (!exchangeRateOptional.isPresent()) continue;
            return exchangeRateOptional.get();
        }
        String datesOnErrors = Stream.of(dates).map(date -> date.format(DateTimeFormatter.ISO_LOCAL_DATE)).collect(Collectors.joining(","));
        throw new MonetaryException("There is not exchange on day " + datesOnErrors + " to rate to  rate on IMFRateProvider.");
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + '{' + " context: " + this.context + '}';
    }

    static {
        for (Currency currency : Currency.getAvailableCurrencies()) {
            CURRENCIES_BY_NAME.put(currency.getDisplayName(Locale.ENGLISH).toLowerCase(Locale.ENGLISH), Monetary.getCurrency((String)currency.getCurrencyCode(), (String[])new String[0]));
        }
        CURRENCIES_BY_NAME.put("U.K. pound".toLowerCase(Locale.ENGLISH), Monetary.getCurrency((String)"GBP", (String[])new String[0]));
        CURRENCIES_BY_NAME.put("U.S. dollar".toLowerCase(Locale.ENGLISH), Monetary.getCurrency((String)"USD", (String[])new String[0]));
        CURRENCIES_BY_NAME.put("Bahrain dinar".toLowerCase(Locale.ENGLISH), Monetary.getCurrency((String)"BHD", (String[])new String[0]));
        CURRENCIES_BY_NAME.put("Botswana pula".toLowerCase(Locale.ENGLISH), Monetary.getCurrency((String)"BWP", (String[])new String[0]));
        CURRENCIES_BY_NAME.put("Czech koruna".toLowerCase(Locale.ENGLISH), Monetary.getCurrency((String)"CZK", (String[])new String[0]));
        CURRENCIES_BY_NAME.put("Icelandic krona".toLowerCase(Locale.ENGLISH), Monetary.getCurrency((String)"ISK", (String[])new String[0]));
        CURRENCIES_BY_NAME.put("Korean won".toLowerCase(Locale.ENGLISH), Monetary.getCurrency((String)"KRW", (String[])new String[0]));
        CURRENCIES_BY_NAME.put("Omani rial".toLowerCase(Locale.ENGLISH), Monetary.getCurrency((String)"OMR", (String[])new String[0]));
        CURRENCIES_BY_NAME.put("Peruvian sol".toLowerCase(Locale.ENGLISH), Monetary.getCurrency((String)"PEN", (String[])new String[0]));
        CURRENCIES_BY_NAME.put("Qatari riyal".toLowerCase(Locale.ENGLISH), Monetary.getCurrency((String)"QAR", (String[])new String[0]));
        CURRENCIES_BY_NAME.put("Saudi Arabian riyal".toLowerCase(Locale.ENGLISH), Monetary.getCurrency((String)"SAR", (String[])new String[0]));
        CURRENCIES_BY_NAME.put("Sri Lankan rupee".toLowerCase(Locale.ENGLISH), Monetary.getCurrency((String)"LKR", (String[])new String[0]));
        CURRENCIES_BY_NAME.put("Trinidadian dollar".toLowerCase(Locale.ENGLISH), Monetary.getCurrency((String)"TTD", (String[])new String[0]));
        CURRENCIES_BY_NAME.put("U.A.E. dirham".toLowerCase(Locale.ENGLISH), Monetary.getCurrency((String)"AED", (String[])new String[0]));
        CURRENCIES_BY_NAME.put("Uruguayan peso".toLowerCase(Locale.ENGLISH), Monetary.getCurrency((String)"UYU", (String[])new String[0]));
        CURRENCIES_BY_NAME.put("Bolivar Fuerte".toLowerCase(Locale.ENGLISH), Monetary.getCurrency((String)"VEF", (String[])new String[0]));
    }
}

