/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.spi;

import javax.money.MonetaryAmount;
import javax.money.convert.ConversionContext;
import javax.money.convert.ConversionQuery;
import javax.money.convert.ConversionQueryBuilder;
import javax.money.convert.CurrencyConversion;
import javax.money.convert.ExchangeRate;
import javax.money.convert.ExchangeRateProvider;
import org.javamoney.moneta.spi.AbstractCurrencyConversion;

public class LazyBoundCurrencyConversion
extends AbstractCurrencyConversion
implements CurrencyConversion {
    private ExchangeRateProvider rateProvider;
    private ConversionQuery conversionQuery;

    public LazyBoundCurrencyConversion(ConversionQuery conversionQuery, ExchangeRateProvider rateProvider, ConversionContext conversionContext) {
        super(conversionQuery.getCurrency(), conversionContext);
        this.conversionQuery = conversionQuery;
        this.rateProvider = rateProvider;
    }

    @Override
    public ExchangeRate getExchangeRate(MonetaryAmount amount) {
        return this.rateProvider.getExchangeRate(ConversionQueryBuilder.of((ConversionQuery)this.conversionQuery).setBaseCurrency(amount.getCurrency()).build());
    }

    public ExchangeRateProvider getExchangeRateProvider() {
        return this.rateProvider;
    }

    @Override
    public CurrencyConversion with(ConversionContext conversionContext) {
        return new LazyBoundCurrencyConversion(this.conversionQuery, this.rateProvider, conversionContext);
    }

    @Override
    public String toString() {
        return "CurrencyConversion [MonetaryAmount -> MonetaryAmount; provider=" + this.rateProvider + ", context=" + this.getContext() + ", termCurrency=" + this.getCurrency() + ']';
    }
}

