/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.spi;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Objects;
import javax.money.NumberValue;
import org.javamoney.moneta.spi.ConvertBigDecimal;
import org.javamoney.moneta.spi.ConvertNumberValue;

public final class DefaultNumberValue
extends NumberValue {
    private static final long serialVersionUID = 1L;
    private final Number number;
    public static final NumberValue ONE = new DefaultNumberValue(BigDecimal.ONE);

    public DefaultNumberValue(Number number) {
        this.number = Objects.requireNonNull(number, "Number required");
    }

    public static NumberValue of(Number number) {
        return new DefaultNumberValue(number);
    }

    public Class<?> getNumberType() {
        return this.number.getClass();
    }

    public int getPrecision() {
        return this.numberValue(BigDecimal.class).precision();
    }

    public int getScale() {
        return DefaultNumberValue.getBigDecimal(this.number).scale();
    }

    public int intValue() {
        return this.number.intValue();
    }

    public int intValueExact() {
        return DefaultNumberValue.getBigDecimal(this.number).intValueExact();
    }

    public long longValue() {
        return this.number.longValue();
    }

    public long longValueExact() {
        return DefaultNumberValue.getBigDecimal(this.number).longValueExact();
    }

    public float floatValue() {
        return this.number.floatValue();
    }

    public double doubleValue() {
        return this.number.doubleValue();
    }

    public double doubleValueExact() {
        double d = this.number.doubleValue();
        if (d == Double.NEGATIVE_INFINITY || d == Double.POSITIVE_INFINITY) {
            throw new ArithmeticException("Unable to convert to double: " + this.number);
        }
        return d;
    }

    public long getAmountFractionNumerator() {
        BigDecimal bd = DefaultNumberValue.getBigDecimal(this.number).remainder(BigDecimal.ONE);
        return bd.movePointRight(this.getScale()).longValueExact();
    }

    public long getAmountFractionDenominator() {
        return BigDecimal.valueOf(10L).pow(this.getScale()).longValueExact();
    }

    public <T extends Number> T numberValue(Class<T> numberType) {
        return ConvertNumberValue.of(numberType, this.number);
    }

    public NumberValue round(MathContext mathContext) {
        if (this.number instanceof BigDecimal) {
            return new DefaultNumberValue(((BigDecimal)this.number).round(mathContext));
        }
        return new DefaultNumberValue(new BigDecimal(this.number.toString()).round(mathContext));
    }

    public <T extends Number> T numberValueExact(Class<T> numberType) {
        return ConvertNumberValue.ofExact(numberType, this.number);
    }

    public String toString() {
        return String.valueOf(this.number);
    }

    protected static BigDecimal getBigDecimal(Number num) {
        return ConvertBigDecimal.of(num);
    }
}

