/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.spi;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Objects;
import java.util.logging.Logger;
import javax.money.NumberValue;
import javax.money.convert.ConversionContext;
import javax.money.convert.ConversionQuery;
import javax.money.convert.CurrencyConversion;
import javax.money.convert.ExchangeRate;
import javax.money.convert.ExchangeRateProvider;
import javax.money.convert.ProviderContext;
import javax.money.convert.RateType;
import org.javamoney.moneta.spi.DefaultNumberValue;
import org.javamoney.moneta.spi.LazyBoundCurrencyConversion;

public abstract class AbstractRateProvider
implements ExchangeRateProvider {
    protected final Logger LOGGER = Logger.getLogger(this.getClass().getName());
    private ProviderContext providerContext;

    public AbstractRateProvider(ProviderContext providerContext) {
        Objects.requireNonNull(providerContext);
        this.providerContext = providerContext;
    }

    public ProviderContext getContext() {
        return this.providerContext;
    }

    public abstract ExchangeRate getExchangeRate(ConversionQuery var1);

    public CurrencyConversion getCurrencyConversion(ConversionQuery conversionQuery) {
        if (this.getContext().getRateTypes().size() == 1) {
            return new LazyBoundCurrencyConversion(conversionQuery, this, ConversionContext.of((String)this.getContext().getProviderName(), (RateType)((RateType)this.getContext().getRateTypes().iterator().next())));
        }
        return new LazyBoundCurrencyConversion(conversionQuery, this, ConversionContext.of((String)this.getContext().getProviderName(), (RateType)RateType.ANY));
    }

    protected static NumberValue multiply(NumberValue multiplicand, NumberValue multiplier) {
        if (Objects.isNull(multiplicand)) {
            throw new ArithmeticException("The multiplicand cannot be null");
        }
        if (Objects.isNull(multiplier)) {
            throw new ArithmeticException("The multiplier cannot be null");
        }
        return new DefaultNumberValue(((BigDecimal)multiplicand.numberValueExact(BigDecimal.class)).multiply((BigDecimal)multiplier.numberValue(BigDecimal.class)));
    }

    protected static NumberValue divide(NumberValue dividend, NumberValue divisor) {
        if (Objects.isNull(dividend)) {
            throw new ArithmeticException("The dividend cannot be null");
        }
        if (Objects.isNull(divisor)) {
            throw new ArithmeticException("The divisor cannot be null");
        }
        return new DefaultNumberValue(((BigDecimal)dividend.numberValueExact(BigDecimal.class)).divide((BigDecimal)divisor.numberValue(BigDecimal.class)));
    }

    protected static NumberValue divide(NumberValue dividend, NumberValue divisor, MathContext context) {
        if (Objects.isNull(dividend)) {
            throw new ArithmeticException("The dividend cannot be null");
        }
        if (Objects.isNull(divisor)) {
            throw new ArithmeticException("The divisor cannot be null");
        }
        return new DefaultNumberValue(((BigDecimal)dividend.numberValueExact(BigDecimal.class)).divide((BigDecimal)divisor.numberValue(BigDecimal.class), context));
    }
}

