/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.spi;

import java.math.BigDecimal;
import java.util.Objects;
import javax.money.AbstractContext;
import javax.money.CurrencyUnit;
import javax.money.MonetaryAmount;
import javax.money.MonetaryAmountFactory;
import javax.money.MonetaryContext;
import javax.money.MonetaryContextBuilder;
import javax.money.MonetaryCurrencies;
import javax.money.MonetaryException;
import org.javamoney.moneta.spi.ConvertBigDecimal;

public abstract class AbstractAmountBuilder<T extends MonetaryAmount>
implements MonetaryAmountFactory<T> {
    private MonetaryContext DEFAULT_MONETARY_CONTEXT = this.loadDefaultMonetaryContext();
    private MonetaryContext MAX_MONETARY_CONTEXT = this.loadMaxMonetaryContext();
    private CurrencyUnit currency;
    private Number number;
    private MonetaryContext monetaryContext = this.DEFAULT_MONETARY_CONTEXT;

    public T create() {
        if (this.currency == null) {
            throw new MonetaryException("Cannot of FastMoney instance: missing currency.");
        }
        if (this.number == null) {
            throw new MonetaryException("Cannot of FastMoney instance: missing number.");
        }
        if (this.monetaryContext == null) {
            throw new MonetaryException("Cannot of FastMoney instance: missing context.");
        }
        return this.create(this.number, this.currency, this.monetaryContext);
    }

    protected abstract T create(Number var1, CurrencyUnit var2, MonetaryContext var3);

    protected abstract MonetaryContext loadDefaultMonetaryContext();

    protected abstract MonetaryContext loadMaxMonetaryContext();

    public MonetaryAmountFactory<T> setCurrency(CurrencyUnit currency) {
        Objects.requireNonNull(currency);
        this.currency = currency;
        return this;
    }

    public MonetaryAmountFactory<T> setNumber(Number number) {
        this.number = AbstractAmountBuilder.getBigDecimal(number);
        return this;
    }

    public MonetaryAmountFactory<T> setCurrency(String currencyCode) {
        this.currency = MonetaryCurrencies.getCurrency((String)currencyCode, (String[])new String[0]);
        return this;
    }

    public MonetaryAmountFactory<T> setNumber(double number) {
        this.number = new BigDecimal(String.valueOf(number));
        return this;
    }

    public MonetaryAmountFactory<T> setNumber(long number) {
        this.number = BigDecimal.valueOf(number);
        return this;
    }

    public MonetaryAmountFactory<T> setContext(MonetaryContext monetaryContext) {
        Objects.requireNonNull(monetaryContext);
        int maxScale = this.getMaximalMonetaryContext().getMaxScale();
        if (maxScale != -1 && maxScale < monetaryContext.getMaxScale()) {
            throw new MonetaryException("Context exceeds maximal capabilities (scale) of this type: " + monetaryContext);
        }
        int precision = this.getMaximalMonetaryContext().getPrecision();
        if (precision != 0 && precision < monetaryContext.getPrecision()) {
            throw new MonetaryException("Contexts exceeds maximal capabilities (precision) of this type: " + monetaryContext);
        }
        this.monetaryContext = monetaryContext;
        return this;
    }

    public MonetaryContext getDefaultMonetaryContext() {
        return this.DEFAULT_MONETARY_CONTEXT;
    }

    public MonetaryContext getMaximalMonetaryContext() {
        return this.MAX_MONETARY_CONTEXT;
    }

    public MonetaryAmountFactory<T> setAmount(MonetaryAmount amt) {
        this.currency = amt.getCurrency();
        this.number = amt.getNumber().numberValue(BigDecimal.class);
        this.monetaryContext = ((MonetaryContextBuilder)MonetaryContextBuilder.of((Class)this.DEFAULT_MONETARY_CONTEXT.getAmountType()).importContext((AbstractContext)amt.getContext())).build();
        return this;
    }

    protected static BigDecimal getBigDecimal(Number num) {
        return ConvertBigDecimal.of(num);
    }
}

