/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.internal;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.money.CurrencyQuery;
import javax.money.CurrencyUnit;
import javax.money.spi.CurrencyProviderSpi;

public class ConfigurableCurrencyUnitProvider
implements CurrencyProviderSpi {
    private static Map<String, CurrencyUnit> currencyUnits = new ConcurrentHashMap<String, CurrencyUnit>();
    private static Map<Locale, CurrencyUnit> currencyUnitsByLocale = new ConcurrentHashMap<Locale, CurrencyUnit>();

    public Set<CurrencyUnit> getCurrencies(CurrencyQuery currencyQuery) {
        HashSet<CurrencyUnit> result = new HashSet<CurrencyUnit>(currencyUnits.size());
        if (currencyQuery.get(LocalDateTime.class) != null || currencyQuery.get(LocalDate.class) != null) {
            return Collections.emptySet();
        }
        if (!currencyQuery.getCurrencyCodes().isEmpty()) {
            for (String code : currencyQuery.getCurrencyCodes()) {
                CurrencyUnit cu = currencyUnits.get(code);
                if (cu == null) continue;
                result.add(cu);
            }
            return result;
        }
        if (!currencyQuery.getCountries().isEmpty()) {
            for (Locale locale : currencyQuery.getCountries()) {
                CurrencyUnit cu = currencyUnitsByLocale.get(locale);
                if (cu == null) continue;
                result.add(cu);
            }
            return result;
        }
        result.addAll(currencyUnits.values());
        return result;
    }

    public static CurrencyUnit registerCurrencyUnit(CurrencyUnit currencyUnit) {
        Objects.requireNonNull(currencyUnit);
        return currencyUnits.put(currencyUnit.getCurrencyCode(), currencyUnit);
    }

    public static CurrencyUnit registerCurrencyUnit(CurrencyUnit currencyUnit, Locale locale) {
        Objects.requireNonNull(locale);
        Objects.requireNonNull(currencyUnit);
        return currencyUnitsByLocale.put(locale, currencyUnit);
    }

    public static CurrencyUnit removeCurrencyUnit(String currencyCode) {
        Objects.requireNonNull(currencyCode);
        return currencyUnits.remove(currencyCode);
    }

    public static CurrencyUnit removeCurrencyUnit(Locale locale) {
        Objects.requireNonNull(locale);
        return currencyUnitsByLocale.remove(locale);
    }

    public String toString() {
        return "ConfigurableCurrencyUnitProvider [currencyUnits=" + currencyUnits + ", currencyUnitsByLocale=" + currencyUnitsByLocale + ']';
    }
}

