/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.function;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.money.CurrencyUnit;
import org.javamoney.moneta.function.DefaultMonetarySummaryStatistics;
import org.javamoney.moneta.function.MonetarySummaryStatistics;

class MonetarySummaryMap
implements Map<CurrencyUnit, MonetarySummaryStatistics> {
    private Map<CurrencyUnit, MonetarySummaryStatistics> map = new HashMap<CurrencyUnit, MonetarySummaryStatistics>();

    MonetarySummaryMap() {
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public MonetarySummaryStatistics get(Object key) {
        if (CurrencyUnit.class.isInstance(key)) {
            CurrencyUnit unit = (CurrencyUnit)CurrencyUnit.class.cast(key);
            return this.map.getOrDefault(unit, new DefaultMonetarySummaryStatistics(unit));
        }
        return this.map.get(key);
    }

    @Override
    public MonetarySummaryStatistics put(CurrencyUnit key, MonetarySummaryStatistics value) {
        return this.map.put(key, value);
    }

    @Override
    public MonetarySummaryStatistics remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public void putAll(Map<? extends CurrencyUnit, ? extends MonetarySummaryStatistics> m) {
        this.map.putAll(m);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<CurrencyUnit> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<MonetarySummaryStatistics> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<CurrencyUnit, MonetarySummaryStatistics>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public boolean equals(Object obj) {
        if (MonetarySummaryMap.class.isInstance(obj)) {
            MonetarySummaryMap other = (MonetarySummaryMap)MonetarySummaryMap.class.cast(obj);
            return this.map.equals(other.map);
        }
        return false;
    }

    @Override
    public MonetarySummaryStatistics putIfAbsent(CurrencyUnit key, MonetarySummaryStatistics value) {
        MonetarySummaryStatistics v = this.map.get(key);
        if (Objects.isNull(v)) {
            v = this.put(key, value);
        }
        return v;
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return "MonetarySummaryMap: " + this.map.toString();
    }
}

