/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.convert.internal;

import java.io.InputStream;
import java.math.BigDecimal;
import java.math.MathContext;
import java.net.MalformedURLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import javax.money.CurrencyUnit;
import javax.money.MonetaryCurrencies;
import javax.money.convert.ConversionContextBuilder;
import javax.money.convert.ConversionQuery;
import javax.money.convert.ExchangeRate;
import javax.money.convert.ProviderContext;
import javax.money.convert.ProviderContextBuilder;
import javax.money.convert.RateType;
import javax.money.spi.Bootstrap;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.javamoney.moneta.ExchangeRateBuilder;
import org.javamoney.moneta.spi.AbstractRateProvider;
import org.javamoney.moneta.spi.DefaultNumberValue;
import org.javamoney.moneta.spi.LoaderService;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ECBHistoricRateProvider
extends AbstractRateProvider
implements LoaderService.LoaderListener {
    private static final String DATA_ID = ECBHistoricRateProvider.class.getSimpleName();
    private static final String BASE_CURRENCY_CODE = "EUR";
    public static final CurrencyUnit BASE_CURRENCY = MonetaryCurrencies.getCurrency((String)"EUR", (String[])new String[0]);
    private final Map<Long, Map<String, ExchangeRate>> historicRates = new ConcurrentHashMap<Long, Map<String, ExchangeRate>>();
    private SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
    private static final ProviderContext CONTEXT = ((ProviderContextBuilder)((ProviderContextBuilder)ProviderContextBuilder.of((String)"ECB-HIST", (RateType)RateType.HISTORIC, (RateType[])new RateType[]{RateType.DEFERRED}).set("providerDescription", (Object)"European Central Bank")).set("days", 1500)).build();

    public ECBHistoricRateProvider() throws MalformedURLException {
        super(CONTEXT);
        this.saxParserFactory.setNamespaceAware(false);
        this.saxParserFactory.setValidating(false);
        LoaderService loader = (LoaderService)Bootstrap.getService(LoaderService.class);
        loader.addLoaderListener(this, DATA_ID);
        loader.loadDataAsync(DATA_ID);
    }

    @Override
    public void newDataLoaded(String data, InputStream is) {
        int oldSize = this.historicRates.size();
        try {
            SAXParser parser = this.saxParserFactory.newSAXParser();
            parser.parse(is, (DefaultHandler)new RateReadingHandler());
        }
        catch (Exception e) {
            this.LOGGER.log(Level.FINEST, "Error during data load.", e);
        }
        int newSize = this.historicRates.size();
        this.LOGGER.info("Loaded " + DATA_ID + " exchange rates for days:" + (newSize - oldSize));
    }

    @Override
    public ProviderContext getProviderContext() {
        return CONTEXT;
    }

    @Override
    public ExchangeRate getExchangeRate(ConversionQuery query) {
        if (Objects.isNull(query.getTimestampMillis())) {
            return null;
        }
        ExchangeRateBuilder builder = new ExchangeRateBuilder(((ConversionContextBuilder)ConversionContextBuilder.create((ProviderContext)CONTEXT, (RateType)RateType.HISTORIC).setTimestampMillis(query.getTimestampMillis().longValue())).build());
        builder.setBase(query.getBaseCurrency());
        builder.setTerm(query.getCurrency());
        if (this.historicRates.isEmpty()) {
            return null;
        }
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        cal.setTimeInMillis(query.getTimestampMillis());
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Long targetTS = cal.getTimeInMillis();
        Map<String, ExchangeRate> targets = this.historicRates.get(targetTS);
        if (Objects.isNull(targets)) {
            return null;
        }
        ExchangeRate sourceRate = targets.get(query.getBaseCurrency().getCurrencyCode());
        ExchangeRate target = targets.get(query.getCurrency().getCurrencyCode());
        if (BASE_CURRENCY_CODE.equals(query.getBaseCurrency().getCurrencyCode()) && BASE_CURRENCY_CODE.equals(query.getCurrency().getCurrencyCode())) {
            builder.setFactor(DefaultNumberValue.ONE);
            return builder.build();
        }
        if (BASE_CURRENCY_CODE.equals(query.getCurrency().getCurrencyCode())) {
            if (Objects.isNull(sourceRate)) {
                return null;
            }
            return ECBHistoricRateProvider.reverse(sourceRate);
        }
        if (BASE_CURRENCY_CODE.equals(query.getBaseCurrency().getCurrencyCode())) {
            return target;
        }
        ExchangeRate rate1 = this.getExchangeRate(query.toBuilder().setTermCurrency(MonetaryCurrencies.getCurrency((String)BASE_CURRENCY_CODE, (String[])new String[0])).build());
        ExchangeRate rate2 = this.getExchangeRate(query.toBuilder().setBaseCurrency(MonetaryCurrencies.getCurrency((String)BASE_CURRENCY_CODE, (String[])new String[0])).setTermCurrency(query.getCurrency()).build());
        if (Objects.nonNull(rate1) || Objects.nonNull(rate2)) {
            builder.setFactor(ECBHistoricRateProvider.multiply(rate1.getFactor(), rate2.getFactor()));
            builder.setRateChain(rate1, rate2);
            return builder.build();
        }
        return null;
    }

    private static ExchangeRate reverse(ExchangeRate rate) {
        if (Objects.isNull(rate)) {
            throw new IllegalArgumentException("Rate null is not reversable.");
        }
        return new ExchangeRateBuilder(rate).setRate(rate).setBase(rate.getCurrency()).setTerm(rate.getBaseCurrency()).setFactor(ECBHistoricRateProvider.divide(DefaultNumberValue.ONE, rate.getFactor(), MathContext.DECIMAL64)).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addRate(CurrencyUnit term, Long timestamp, Number rate) {
        ExchangeRateBuilder builder;
        RateType rateType = RateType.HISTORIC;
        if (Objects.nonNull(timestamp)) {
            if (timestamp > System.currentTimeMillis()) {
                rateType = RateType.DEFERRED;
            }
            builder = new ExchangeRateBuilder(((ConversionContextBuilder)ConversionContextBuilder.create((ProviderContext)CONTEXT, (RateType)rateType).setTimestampMillis(timestamp.longValue())).build());
        } else {
            builder = new ExchangeRateBuilder(ConversionContextBuilder.create((ProviderContext)CONTEXT, (RateType)rateType).build());
        }
        builder.setBase(BASE_CURRENCY);
        builder.setTerm(term);
        builder.setFactor(DefaultNumberValue.of(rate));
        ExchangeRate exchangeRate = builder.build();
        Map rateMap = this.historicRates.get(timestamp);
        if (Objects.isNull(rateMap)) {
            Map<Long, Map<String, ExchangeRate>> map = this.historicRates;
            synchronized (map) {
                rateMap = Optional.ofNullable(this.historicRates.get(timestamp)).orElse(new ConcurrentHashMap());
                this.historicRates.putIfAbsent(timestamp, rateMap);
            }
        }
        rateMap.put((String)term.getCurrencyCode(), (ExchangeRate)exchangeRate);
    }

    private class RateReadingHandler
    extends DefaultHandler {
        private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        private Long timestamp;

        public RateReadingHandler() {
            this.dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            try {
                if ("Cube".equals(qName)) {
                    if (Objects.nonNull(attributes.getValue("time"))) {
                        Date date = this.dateFormat.parse(attributes.getValue("time"));
                        this.timestamp = date.getTime();
                    } else if (Objects.nonNull(attributes.getValue("currency"))) {
                        CurrencyUnit tgtCurrency = MonetaryCurrencies.getCurrency((String)attributes.getValue("currency"), (String[])new String[0]);
                        ECBHistoricRateProvider.this.addRate(tgtCurrency, this.timestamp, BigDecimal.valueOf(Double.parseDouble(attributes.getValue("rate"))));
                    }
                }
                super.startElement(uri, localName, qName, attributes);
            }
            catch (ParseException e) {
                throw new SAXException("Failed to read.", e);
            }
        }
    }
}

