/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.spi;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Objects;
import javax.money.CurrencyUnit;
import javax.money.MonetaryAmount;
import javax.money.MonetaryContext;
import javax.money.MonetaryException;
import org.javamoney.moneta.spi.ConvertBigDecimal;

public final class MoneyUtils {
    private MoneyUtils() {
    }

    public static BigDecimal getBigDecimal(long num) {
        return BigDecimal.valueOf(num);
    }

    public static BigDecimal getBigDecimal(double num) {
        return new BigDecimal(String.valueOf(num));
    }

    public static BigDecimal getBigDecimal(Number num) {
        return ConvertBigDecimal.of(num);
    }

    public static BigDecimal getBigDecimal(Number num, MonetaryContext moneyContext) {
        BigDecimal bd = MoneyUtils.getBigDecimal(num);
        if (Objects.nonNull(moneyContext)) {
            return new BigDecimal(bd.toString(), MoneyUtils.getMathContext(moneyContext, RoundingMode.HALF_EVEN));
        }
        return bd;
    }

    public static MathContext getMathContext(MonetaryContext monetaryContext, RoundingMode defaultMode) {
        MathContext ctx = (MathContext)monetaryContext.get(MathContext.class);
        if (Objects.nonNull(ctx)) {
            return ctx;
        }
        if (Objects.nonNull((Object)defaultMode)) {
            return new MathContext(monetaryContext.getPrecision(), (RoundingMode)((Object)monetaryContext.get(RoundingMode.class, (Object)defaultMode)));
        }
        return new MathContext(monetaryContext.getPrecision(), (RoundingMode)((Object)monetaryContext.get(RoundingMode.class, (Object)RoundingMode.HALF_EVEN)));
    }

    public static void checkAmountParameter(MonetaryAmount amount, CurrencyUnit currencyUnit) {
        Objects.requireNonNull(amount, "Amount must not be null.");
        CurrencyUnit amountCurrency = amount.getCurrency();
        if (!currencyUnit.getCurrencyCode().equals(amountCurrency.getCurrencyCode())) {
            throw new MonetaryException("Currency mismatch: " + currencyUnit + '/' + amountCurrency);
        }
    }

    public static void checkNumberParameter(Number number) {
        Objects.requireNonNull(number, "Number is required.");
    }
}

