/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.spi;

import java.util.Objects;
import javax.money.CurrencyUnit;
import javax.money.MonetaryAmount;
import javax.money.convert.ConversionContext;
import javax.money.convert.CurrencyConversion;
import javax.money.convert.CurrencyConversionException;
import javax.money.convert.ExchangeRate;

public abstract class AbstractCurrencyConversion
implements CurrencyConversion {
    private CurrencyUnit termCurrency;
    private ConversionContext conversionContext;

    public AbstractCurrencyConversion(CurrencyUnit termCurrency, ConversionContext conversionContext) {
        Objects.requireNonNull(termCurrency);
        Objects.requireNonNull(conversionContext);
        this.termCurrency = termCurrency;
        this.conversionContext = conversionContext;
    }

    public CurrencyUnit getCurrency() {
        return this.termCurrency;
    }

    public ConversionContext getConversionContext() {
        return this.conversionContext;
    }

    public abstract ExchangeRate getExchangeRate(MonetaryAmount var1);

    public abstract CurrencyConversion with(ConversionContext var1);

    public MonetaryAmount apply(MonetaryAmount amount) {
        if (this.termCurrency.equals(Objects.requireNonNull(amount).getCurrency())) {
            return amount;
        }
        ExchangeRate rate = this.getExchangeRate(amount);
        if (Objects.isNull(rate) || !amount.getCurrency().equals(rate.getBaseCurrency())) {
            throw new CurrencyConversionException(amount.getCurrency(), Objects.isNull(rate) ? null : rate.getCurrency(), null);
        }
        return amount.multiply((Number)rate.getFactor()).getFactory().setCurrency(rate.getCurrency()).create();
    }

    public String toString() {
        return this.getClass().getName() + " [MonetaryAmount -> MonetaryAmount" + ']';
    }
}

