/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.money.CurrencyUnit;
import javax.money.MonetaryAmount;
import javax.money.MonetaryAmountFactory;
import javax.money.MonetaryContext;
import javax.money.MonetaryContextBuilder;
import javax.money.MonetaryCurrencies;
import javax.money.MonetaryException;
import javax.money.MonetaryOperator;
import javax.money.MonetaryQuery;
import javax.money.NumberValue;
import javax.money.format.MonetaryAmountFormat;
import org.javamoney.moneta.ToStringMonetaryAmountFormat;
import org.javamoney.moneta.internal.FastMoneyAmountBuilder;
import org.javamoney.moneta.spi.DefaultNumberValue;
import org.javamoney.moneta.spi.MonetaryConfig;
import org.javamoney.moneta.spi.MoneyUtils;

public final class FastMoney
implements MonetaryAmount,
Comparable<MonetaryAmount>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(FastMoney.class.getName());
    private final CurrencyUnit currency;
    private final long number;
    private static final int SCALE = 5;
    private static final MonetaryContext MONETARY_CONTEXT = MonetaryContextBuilder.of(FastMoney.class).setMaxScale(5).setFixedScale(true).setPrecision(19).build();
    public static final FastMoney MAX_VALUE = new FastMoney(Long.MAX_VALUE, MonetaryCurrencies.getCurrency((String)"XXX", (String[])new String[0]));
    private static final BigDecimal MAX_BD = MAX_VALUE.getBigDecimal();
    public static final FastMoney MIN_VALUE = new FastMoney(Long.MIN_VALUE, MonetaryCurrencies.getCurrency((String)"XXX", (String[])new String[0]));
    private static final BigDecimal MIN_BD = MIN_VALUE.getBigDecimal();
    private static ToStringMonetaryAmountFormat DEFAULT_FORMATTER = ToStringMonetaryAmountFormat.of(ToStringMonetaryAmountFormat.ToStringMonetaryAmountFormatStyle.FAST_MONEY);

    private FastMoney(Number number, CurrencyUnit currency, boolean allowInternalRounding) {
        Objects.requireNonNull(currency, "Currency is required.");
        this.currency = currency;
        Objects.requireNonNull(number, "Number is required.");
        this.number = this.getInternalNumber(number, allowInternalRounding);
    }

    private FastMoney(NumberValue numberValue, CurrencyUnit currency, boolean allowInternalRounding) {
        Objects.requireNonNull(currency, "Currency is required.");
        this.currency = currency;
        Objects.requireNonNull(numberValue, "Number is required.");
        this.number = this.getInternalNumber(numberValue.numberValue(BigDecimal.class), allowInternalRounding);
    }

    private FastMoney(long number, CurrencyUnit currency) {
        Objects.requireNonNull(currency, "Currency is required.");
        this.currency = currency;
        this.number = number;
    }

    public CurrencyUnit getCurrency() {
        return this.currency;
    }

    public MonetaryContext getMonetaryContext() {
        return MONETARY_CONTEXT;
    }

    private long getInternalNumber(Number number, boolean allowInternalRounding) {
        BigDecimal bd = MoneyUtils.getBigDecimal(number);
        if (!allowInternalRounding && bd.scale() > 5) {
            throw new ArithmeticException(number + " can not be represented by this class, scale > " + 5);
        }
        if (bd.compareTo(MIN_BD) < 0) {
            throw new ArithmeticException("Overflow: " + number + " < " + MIN_BD);
        }
        if (bd.compareTo(MAX_BD) > 0) {
            throw new ArithmeticException("Overflow: " + number + " > " + MAX_BD);
        }
        return bd.movePointRight(5).longValue();
    }

    public static FastMoney of(NumberValue numberBinding, CurrencyUnit currency) {
        return new FastMoney(numberBinding, currency, false);
    }

    public static FastMoney of(Number number, CurrencyUnit currency) {
        return new FastMoney(number, currency, false);
    }

    public static FastMoney of(Number number, String currencyCode) {
        CurrencyUnit currency = MonetaryCurrencies.getCurrency((String)currencyCode, (String[])new String[0]);
        return FastMoney.of(number, currency);
    }

    @Override
    public int compareTo(MonetaryAmount o) {
        Objects.requireNonNull(o);
        int compare = this.getCurrency().getCurrencyCode().compareTo(o.getCurrency().getCurrencyCode());
        if (compare == 0) {
            compare = ((BigDecimal)this.getNumber().numberValue(BigDecimal.class)).compareTo((BigDecimal)o.getNumber().numberValue(BigDecimal.class));
        }
        return compare;
    }

    public int hashCode() {
        return Objects.hash(this.currency, this.number);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof FastMoney) {
            FastMoney other = (FastMoney)obj;
            return Objects.equals(this.currency, other.currency) && Objects.equals(this.number, other.number);
        }
        return false;
    }

    public FastMoney abs() {
        if (this.isPositiveOrZero()) {
            return this;
        }
        return this.negate();
    }

    public FastMoney add(MonetaryAmount amount) {
        this.checkAmountParameter(amount);
        if (amount.isZero()) {
            return this;
        }
        return new FastMoney(Math.addExact(this.number, this.getInternalNumber((Number)amount.getNumber(), false)), this.getCurrency());
    }

    private void checkAmountParameter(MonetaryAmount amount) {
        MoneyUtils.checkAmountParameter(amount, this.currency);
        if (amount.getNumber().getScale() > 5) {
            throw new ArithmeticException("Parameter exceeds maximal scale: 5");
        }
        if (amount.getNumber().getPrecision() > MAX_BD.precision()) {
            throw new ArithmeticException("Parameter exceeds maximal precision: 5");
        }
    }

    public FastMoney divide(Number divisor) {
        this.checkNumber(divisor);
        if (this.isOne(divisor)) {
            return this;
        }
        return new FastMoney(Math.round((double)this.number / divisor.doubleValue()), this.getCurrency());
    }

    public FastMoney[] divideAndRemainder(Number divisor) {
        this.checkNumber(divisor);
        if (this.isOne(divisor)) {
            return new FastMoney[]{this, FastMoney.of((Number)0, this.getCurrency())};
        }
        BigDecimal div = MoneyUtils.getBigDecimal(divisor);
        BigDecimal[] res = this.getBigDecimal().divideAndRemainder(div);
        return new FastMoney[]{new FastMoney(res[0], this.getCurrency(), true), new FastMoney(res[1], this.getCurrency(), true)};
    }

    public FastMoney divideToIntegralValue(Number divisor) {
        this.checkNumber(divisor);
        if (this.isOne(divisor)) {
            return this;
        }
        BigDecimal div = MoneyUtils.getBigDecimal(divisor);
        return new FastMoney(this.getBigDecimal().divideToIntegralValue(div), this.getCurrency(), false);
    }

    public FastMoney multiply(Number multiplicand) {
        this.checkNumber(multiplicand);
        if (this.isOne(multiplicand)) {
            return this;
        }
        return new FastMoney(Math.multiplyExact(this.number, this.getInternalNumber(multiplicand, false)) / 100000L, this.getCurrency());
    }

    public FastMoney negate() {
        return new FastMoney(Math.multiplyExact(this.number, -1L), this.getCurrency());
    }

    public FastMoney plus() {
        if (this.number >= 0L) {
            return this;
        }
        return new FastMoney(Math.multiplyExact(this.number, -1L), this.getCurrency());
    }

    public FastMoney subtract(MonetaryAmount subtrahend) {
        this.checkAmountParameter(subtrahend);
        if (subtrahend.isZero()) {
            return this;
        }
        return new FastMoney(Math.subtractExact(this.number, this.getInternalNumber((Number)subtrahend.getNumber(), false)), this.getCurrency());
    }

    public FastMoney remainder(Number divisor) {
        this.checkNumber(divisor);
        if (this.isOne(divisor)) {
            return new FastMoney(0L, this.getCurrency());
        }
        return new FastMoney(this.number % this.getInternalNumber(divisor, false), this.getCurrency());
    }

    private boolean isOne(Number number) {
        BigDecimal bd = MoneyUtils.getBigDecimal(number);
        try {
            return bd.scale() == 0 && bd.longValueExact() == 1L;
        }
        catch (Exception e) {
            return false;
        }
    }

    public FastMoney scaleByPowerOfTen(int n) {
        return new FastMoney(((BigDecimal)this.getNumber().numberValue(BigDecimal.class)).scaleByPowerOfTen(n), this.getCurrency(), true);
    }

    public boolean isZero() {
        return this.number == 0L;
    }

    public boolean isPositive() {
        return this.number > 0L;
    }

    public boolean isPositiveOrZero() {
        return this.number >= 0L;
    }

    public boolean isNegative() {
        return this.number < 0L;
    }

    public boolean isNegativeOrZero() {
        return this.number <= 0L;
    }

    public int getScale() {
        return 5;
    }

    public int getPrecision() {
        return ((BigDecimal)this.getNumber().numberValue(BigDecimal.class)).precision();
    }

    public int signum() {
        if (this.number < 0L) {
            return -1;
        }
        if (this.number == 0L) {
            return 0;
        }
        return 1;
    }

    public boolean isLessThan(MonetaryAmount amount) {
        this.checkAmountParameter(amount);
        return this.getBigDecimal().compareTo((BigDecimal)amount.getNumber().numberValue(BigDecimal.class)) < 0;
    }

    public boolean isLessThan(Number number) {
        this.checkNumber(number);
        return this.getBigDecimal().compareTo(MoneyUtils.getBigDecimal(number)) < 0;
    }

    public boolean isLessThanOrEqualTo(MonetaryAmount amount) {
        this.checkAmountParameter(amount);
        return this.getBigDecimal().compareTo((BigDecimal)amount.getNumber().numberValue(BigDecimal.class)) <= 0;
    }

    public boolean isLessThanOrEqualTo(Number number) {
        this.checkNumber(number);
        return this.getBigDecimal().compareTo(MoneyUtils.getBigDecimal(number)) <= 0;
    }

    public boolean isGreaterThan(MonetaryAmount amount) {
        this.checkAmountParameter(amount);
        return this.getBigDecimal().compareTo((BigDecimal)amount.getNumber().numberValue(BigDecimal.class)) > 0;
    }

    public boolean isGreaterThan(Number number) {
        this.checkNumber(number);
        return this.getBigDecimal().compareTo(MoneyUtils.getBigDecimal(number)) > 0;
    }

    public boolean isGreaterThanOrEqualTo(MonetaryAmount amount) {
        this.checkAmountParameter(amount);
        return this.getBigDecimal().compareTo((BigDecimal)amount.getNumber().numberValue(BigDecimal.class)) >= 0;
    }

    public boolean isGreaterThanOrEqualTo(Number number) {
        this.checkNumber(number);
        return this.getBigDecimal().compareTo(MoneyUtils.getBigDecimal(number)) >= 0;
    }

    public boolean isEqualTo(MonetaryAmount amount) {
        this.checkAmountParameter(amount);
        return this.getBigDecimal().compareTo((BigDecimal)amount.getNumber().numberValue(BigDecimal.class)) == 0;
    }

    public boolean hasSameNumberAs(Number number) {
        this.checkNumber(number);
        try {
            return this.number == this.getInternalNumber(number, false);
        }
        catch (ArithmeticException e) {
            return false;
        }
    }

    public NumberValue getNumber() {
        return new DefaultNumberValue(this.getBigDecimal());
    }

    public String toString() {
        return this.currency.toString() + ' ' + this.getBigDecimal();
    }

    protected void checkNumber(Number number) {
        Objects.requireNonNull(number, "Number is required.");
        if (number.longValue() > MAX_BD.longValue()) {
            throw new ArithmeticException("Value exceeds maximal value: " + MAX_BD);
        }
        BigDecimal bd = MoneyUtils.getBigDecimal(number);
        if (bd.precision() > MAX_BD.precision()) {
            throw new ArithmeticException("Precision exceeds maximal precision: " + MAX_BD.precision());
        }
        if (bd.scale() > 5) {
            if (Boolean.parseBoolean(MonetaryConfig.getConfig().getOrDefault("org.javamoney.moneta.FastMoney.enforceScaleCompatibility", "false"))) {
                throw new ArithmeticException("Scale of " + bd + " exceeds maximal scale: " + 5);
            }
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Scale exceeds maximal scale of FastMoney (5), implicit rounding will be applied to " + number);
            }
        }
    }

    public FastMoney with(MonetaryOperator operator) {
        Objects.requireNonNull(operator);
        try {
            return (FastMoney)FastMoney.class.cast(operator.apply((Object)this));
        }
        catch (ArithmeticException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MonetaryException("Operator failed: " + operator, (Throwable)e);
        }
    }

    public <R> R query(MonetaryQuery<R> query) {
        Objects.requireNonNull(query);
        try {
            return (R)query.queryFrom((MonetaryAmount)this);
        }
        catch (ArithmeticException | MonetaryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MonetaryException("Query failed: " + query, (Throwable)e);
        }
    }

    public static FastMoney from(MonetaryAmount amount) {
        if (FastMoney.class.isInstance(amount)) {
            return (FastMoney)FastMoney.class.cast(amount);
        }
        return new FastMoney(amount.getNumber(), amount.getCurrency(), false);
    }

    public static FastMoney parse(CharSequence text) {
        return FastMoney.parse(text, DEFAULT_FORMATTER);
    }

    public static FastMoney parse(CharSequence text, MonetaryAmountFormat formatter) {
        return FastMoney.from(formatter.parse(text));
    }

    private BigDecimal getBigDecimal() {
        return BigDecimal.valueOf(this.number).movePointLeft(5);
    }

    public FastMoney multiply(double amount) {
        if (amount == 1.0) {
            return this;
        }
        if (amount == 0.0) {
            return new FastMoney(0L, this.currency);
        }
        return new FastMoney(Math.round((double)this.number * amount), this.currency);
    }

    public FastMoney divide(long amount) {
        if (amount == 1L) {
            return this;
        }
        return new FastMoney(this.number / amount, this.currency);
    }

    public FastMoney divide(double number) {
        if (number == 1.0) {
            return this;
        }
        return new FastMoney(Math.round((double)this.number / number), this.getCurrency());
    }

    public FastMoney remainder(long number) {
        return this.remainder(BigDecimal.valueOf(number));
    }

    public FastMoney remainder(double amount) {
        return this.remainder(new BigDecimal(String.valueOf(amount)));
    }

    public FastMoney[] divideAndRemainder(long amount) {
        return this.divideAndRemainder(BigDecimal.valueOf(amount));
    }

    public FastMoney[] divideAndRemainder(double amount) {
        return this.divideAndRemainder(new BigDecimal(String.valueOf(amount)));
    }

    public FastMoney stripTrailingZeros() {
        return this;
    }

    public FastMoney multiply(long multiplicand) {
        if (multiplicand == 1L) {
            return this;
        }
        if (multiplicand == 0L) {
            return new FastMoney(0L, this.currency);
        }
        return new FastMoney(Math.multiplyExact(multiplicand, this.number), this.currency);
    }

    public FastMoney divideToIntegralValue(long divisor) {
        if (divisor == 1L) {
            return this;
        }
        return this.divideToIntegralValue(MoneyUtils.getBigDecimal(divisor));
    }

    public FastMoney divideToIntegralValue(double divisor) {
        if (divisor == 1.0) {
            return this;
        }
        return this.divideToIntegralValue(MoneyUtils.getBigDecimal(divisor));
    }

    public MonetaryAmountFactory<FastMoney> getFactory() {
        return new FastMoneyAmountBuilder().setAmount(this);
    }
}

