/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.spi;

import javax.money.CurrencyUnit;
import javax.money.MonetaryAmount;
import javax.money.convert.ConversionContext;
import javax.money.convert.CurrencyConversion;
import javax.money.convert.ExchangeRate;
import javax.money.convert.ExchangeRateProvider;
import org.javamoney.moneta.spi.AbstractCurrencyConversion;

public class LazyBoundCurrencyConversion
extends AbstractCurrencyConversion
implements CurrencyConversion {
    private ExchangeRateProvider rateProvider;

    public LazyBoundCurrencyConversion(CurrencyUnit termCurrency, ExchangeRateProvider rateProvider, ConversionContext conversionContext) {
        super(termCurrency, conversionContext);
        this.rateProvider = rateProvider;
    }

    @Override
    public ExchangeRate getExchangeRate(MonetaryAmount amount) {
        return this.rateProvider.getExchangeRate(amount.getCurrency(), this.getCurrency());
    }

    @Override
    public CurrencyConversion with(ConversionContext conversionContext) {
        return new LazyBoundCurrencyConversion(this.getCurrency(), this.rateProvider, conversionContext);
    }

    @Override
    public String toString() {
        return "CurrencyConversion [MonetaryAmount -> MonetaryAmount; provider=" + this.rateProvider + ", context=" + this.getConversionContext() + ", termCurrency=" + this.getCurrency() + "]";
    }
}

