/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.function;

import java.util.Objects;
import javax.money.CurrencyUnit;
import javax.money.MonetaryAmount;
import org.javamoney.moneta.FastMoney;
import org.javamoney.moneta.function.MonetaryFunctions;

public class MonetarySummaryStatistics {
    private final MonetaryAmount empty;
    private long count;
    private MonetaryAmount min;
    private MonetaryAmount max;
    private MonetaryAmount sum;
    private MonetaryAmount average;

    MonetarySummaryStatistics(CurrencyUnit currencyUnit) {
        this.empty = FastMoney.of((Number)0, Objects.requireNonNull(currencyUnit));
        this.setSameMonetary(this.empty);
    }

    public void accept(MonetaryAmount amount) {
        if (!this.empty.getCurrency().equals(Objects.requireNonNull(amount).getCurrency())) {
            return;
        }
        if (this.isEmpty()) {
            this.setSameMonetary(amount);
            ++this.count;
        } else {
            this.doSummary(amount);
        }
    }

    public MonetarySummaryStatistics combine(MonetarySummaryStatistics summaryStatistics) {
        Objects.requireNonNull(summaryStatistics);
        if (!this.equals(summaryStatistics)) {
            return this;
        }
        this.min = MonetaryFunctions.min(this.min, summaryStatistics.min);
        this.max = MonetaryFunctions.max(this.max, summaryStatistics.max);
        this.sum = this.sum.add(summaryStatistics.sum);
        this.count += summaryStatistics.count;
        this.average = this.sum.divide(this.count);
        return this;
    }

    private void doSummary(MonetaryAmount moneraty) {
        this.min = MonetaryFunctions.min(this.min, moneraty);
        this.max = MonetaryFunctions.max(this.max, moneraty);
        this.sum = this.sum.add(moneraty);
        this.average = this.sum.divide(++this.count);
    }

    private boolean isEmpty() {
        return this.count == 0L;
    }

    private void setSameMonetary(MonetaryAmount monetary) {
        this.min = monetary;
        this.max = monetary;
        this.sum = monetary;
        this.average = monetary;
    }

    public long getCount() {
        return this.count;
    }

    public MonetaryAmount getMin() {
        return this.min;
    }

    public MonetaryAmount getMax() {
        return this.max;
    }

    public MonetaryAmount getSum() {
        return this.sum;
    }

    public MonetaryAmount getAverage() {
        return this.average;
    }

    public boolean equals(Object obj) {
        if (MonetarySummaryStatistics.class.isInstance(obj)) {
            MonetarySummaryStatistics other = (MonetarySummaryStatistics)MonetarySummaryStatistics.class.cast(obj);
            return Objects.equals(this.empty.getCurrency(), other.empty.getCurrency());
        }
        return false;
    }

    public int hashCode() {
        return this.empty.getCurrency().hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[currency: ").append(this.empty.getCurrency()).append(",");
        sb.append("count:").append(this.count).append(",");
        sb.append("min:").append(this.min).append(",");
        sb.append("max:").append(this.max).append(",");
        sb.append("sum:").append(this.sum).append(",");
        sb.append("average:").append(this.average).append("]");
        return sb.toString();
    }
}

