/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.function;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BinaryOperator;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import javax.money.CurrencySupplier;
import javax.money.CurrencyUnit;
import javax.money.MonetaryAmount;
import javax.money.NumberSupplier;
import org.javamoney.moneta.function.GroupMonetarySummaryStatistics;
import org.javamoney.moneta.function.MonetarySummaryStatistics;
import org.javamoney.moneta.spi.MoneyUtils;

public final class MonetaryFunctions {
    public static Collector<MonetaryAmount, ?, Map<CurrencyUnit, List<MonetaryAmount>>> groupByCurrencyUnit() {
        return Collectors.groupingBy(CurrencySupplier::getCurrency);
    }

    public static Collector<MonetaryAmount, MonetarySummaryStatistics, MonetarySummaryStatistics> summarizingMonetary(CurrencyUnit currencyUnit) {
        Supplier<MonetarySummaryStatistics> supplier = () -> new MonetarySummaryStatistics(currencyUnit);
        return Collector.of(supplier, MonetarySummaryStatistics::accept, MonetarySummaryStatistics::combine, new Collector.Characteristics[0]);
    }

    public static Collector<MonetaryAmount, GroupMonetarySummaryStatistics, GroupMonetarySummaryStatistics> groupBySummarizingMonetary() {
        return Collector.of(GroupMonetarySummaryStatistics::new, GroupMonetarySummaryStatistics::accept, GroupMonetarySummaryStatistics::combine, new Collector.Characteristics[0]);
    }

    public static Comparator<MonetaryAmount> sortCurrencyUnit() {
        return Comparator.comparing(CurrencySupplier::getCurrency);
    }

    public static Comparator<MonetaryAmount> sortCurrencyUnitDesc() {
        return MonetaryFunctions.sortCurrencyUnit().reversed();
    }

    public static Comparator<MonetaryAmount> sortNumber() {
        return Comparator.comparing(NumberSupplier::getNumber);
    }

    public static Comparator<MonetaryAmount> sortNumberDesc() {
        return MonetaryFunctions.sortNumber().reversed();
    }

    public static Predicate<MonetaryAmount> isCurrency(CurrencyUnit ... currencies) {
        if (Objects.isNull(currencies) || currencies.length == 0) {
            return m -> true;
        }
        Predicate<MonetaryAmount> predicate = null;
        for (CurrencyUnit currencyUnit : currencies) {
            predicate = Objects.isNull(predicate) ? m -> m.getCurrency().equals(currencyUnit) : predicate.or(m -> m.getCurrency().equals(currencyUnit));
        }
        return predicate;
    }

    public static Predicate<MonetaryAmount> fiterByExcludingCurrency(CurrencyUnit ... currencies) {
        if (Objects.isNull(currencies) || currencies.length == 0) {
            return m -> true;
        }
        return MonetaryFunctions.isCurrency(currencies).negate();
    }

    public static Predicate<MonetaryAmount> isGreaterThan(MonetaryAmount amount) {
        return m -> m.isGreaterThan(amount);
    }

    public static Predicate<MonetaryAmount> isGreaterThanOrEqualTo(MonetaryAmount amount) {
        return m -> m.isGreaterThanOrEqualTo(amount);
    }

    public static Predicate<MonetaryAmount> isLessThan(MonetaryAmount amount) {
        return m -> m.isLessThan(amount);
    }

    public static Predicate<MonetaryAmount> isLessThanOrEqualTo(MonetaryAmount amount) {
        return m -> m.isLessThanOrEqualTo(amount);
    }

    public static Predicate<MonetaryAmount> isBetween(MonetaryAmount min, MonetaryAmount max) {
        return MonetaryFunctions.isLessThanOrEqualTo(max).and(MonetaryFunctions.isGreaterThanOrEqualTo(min));
    }

    public static MonetaryAmount sum(MonetaryAmount a, MonetaryAmount b) {
        MoneyUtils.checkAmountParameter(Objects.requireNonNull(a), Objects.requireNonNull(b.getCurrency()));
        return a.add(b);
    }

    public static MonetaryAmount min(MonetaryAmount a, MonetaryAmount b) {
        MoneyUtils.checkAmountParameter(Objects.requireNonNull(a), Objects.requireNonNull(b.getCurrency()));
        return a.isLessThan(b) ? a : b;
    }

    public static MonetaryAmount max(MonetaryAmount a, MonetaryAmount b) {
        MoneyUtils.checkAmountParameter(Objects.requireNonNull(a), Objects.requireNonNull(b.getCurrency()));
        return a.isGreaterThan(b) ? a : b;
    }

    public static BinaryOperator<MonetaryAmount> sum() {
        return MonetaryFunctions::sum;
    }

    public static BinaryOperator<MonetaryAmount> min() {
        return MonetaryFunctions::min;
    }

    public static BinaryOperator<MonetaryAmount> max() {
        return MonetaryFunctions::max;
    }
}

