/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.convert.internal;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Currency;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import javax.money.CurrencyContextBuilder;
import javax.money.CurrencyUnit;
import javax.money.MonetaryCurrencies;
import javax.money.convert.ConversionContext;
import javax.money.convert.ConversionContextBuilder;
import javax.money.convert.ConversionQuery;
import javax.money.convert.ExchangeRate;
import javax.money.convert.ProviderContext;
import javax.money.convert.ProviderContextBuilder;
import javax.money.convert.RateType;
import javax.money.spi.Bootstrap;
import org.javamoney.moneta.CurrencyUnitBuilder;
import org.javamoney.moneta.ExchangeRateBuilder;
import org.javamoney.moneta.spi.AbstractRateProvider;
import org.javamoney.moneta.spi.DefaultNumberValue;
import org.javamoney.moneta.spi.LoaderService;

public class IMFRateProvider
extends AbstractRateProvider
implements LoaderService.LoaderListener {
    private static final String DATA_ID = IMFRateProvider.class.getSimpleName();
    private static final ProviderContext CONTEXT = ((ProviderContextBuilder)((ProviderContextBuilder)ProviderContextBuilder.of((String)"IMF", (RateType)RateType.DEFERRED, (RateType[])new RateType[0]).set((Object)"providerDescription", "International Monetary Fond")).set((Object)"days", 1)).build();
    private static final CurrencyUnit SDR = CurrencyUnitBuilder.of("SDR", CurrencyContextBuilder.of((String)IMFRateProvider.class.getSimpleName()).build()).setDefaultFractionDigits(3).build(true);
    private Map<CurrencyUnit, List<ExchangeRate>> currencyToSdr = new HashMap<CurrencyUnit, List<ExchangeRate>>();
    private Map<CurrencyUnit, List<ExchangeRate>> sdrToCurrency = new HashMap<CurrencyUnit, List<ExchangeRate>>();
    private static Map<String, CurrencyUnit> currenciesByName = new HashMap<String, CurrencyUnit>();

    public IMFRateProvider() throws MalformedURLException {
        super(CONTEXT);
        LoaderService loader = (LoaderService)Bootstrap.getService(LoaderService.class);
        loader.addLoaderListener(this, DATA_ID);
        loader.loadDataAsync(DATA_ID);
    }

    @Override
    public void newDataLoaded(String data, InputStream is) {
        try {
            this.loadRatesTSV(is);
        }
        catch (Exception e) {
            this.LOGGER.log(Level.SEVERE, "Error", e);
        }
    }

    private void loadRatesTSV(InputStream inputStream) throws IOException, ParseException {
        HashMap<CurrencyUnit, List<ExchangeRate>> newCurrencyToSdr = new HashMap<CurrencyUnit, List<ExchangeRate>>();
        HashMap<CurrencyUnit, List<ExchangeRate>> newSdrToCurrency = new HashMap<CurrencyUnit, List<ExchangeRate>>();
        DecimalFormat f = new DecimalFormat("#0.0000000000");
        ((NumberFormat)f).setGroupingUsed(false);
        BufferedReader pr = new BufferedReader(new InputStreamReader(inputStream));
        String line = pr.readLine();
        boolean currencyToSdr = true;
        List<Long> timestamps = null;
        while (Objects.nonNull(line)) {
            if (line.trim().isEmpty()) {
                line = pr.readLine();
                continue;
            }
            if (line.startsWith("SDRs per Currency unit")) {
                currencyToSdr = false;
                line = pr.readLine();
                continue;
            }
            if (line.startsWith("Currency units per SDR")) {
                currencyToSdr = true;
                line = pr.readLine();
                continue;
            }
            if (line.startsWith("Currency")) {
                timestamps = this.readTimestamps(line);
                line = pr.readLine();
                continue;
            }
            String[] parts = line.split("\\t");
            CurrencyUnit currency = currenciesByName.get(parts[0]);
            if (Objects.isNull(currency)) {
                this.LOGGER.warning("Unknown currency from, IMF data feed: " + parts[0]);
                line = pr.readLine();
                continue;
            }
            Double[] values = this.parseValues(f, parts);
            for (int i = 0; i < values.length; ++i) {
                ExchangeRate rate;
                List<ExchangeRate> rates;
                Long fromTS;
                if (Objects.isNull(values[i])) continue;
                Long l = fromTS = timestamps != null ? timestamps.get(i) : null;
                if (fromTS == null) continue;
                Long toTS = fromTS + 86400000L;
                RateType rateType = RateType.HISTORIC;
                if (toTS > System.currentTimeMillis()) {
                    rateType = RateType.DEFERRED;
                }
                if (currencyToSdr) {
                    rates = this.currencyToSdr.get(currency);
                    if (Objects.isNull(rates)) {
                        rates = new ArrayList<ExchangeRate>(5);
                        newCurrencyToSdr.put(currency, rates);
                    }
                    rate = new ExchangeRateBuilder(((ConversionContextBuilder)ConversionContextBuilder.create((ProviderContext)CONTEXT, (RateType)rateType).setTimestampMillis(toTS.longValue())).build()).setBase(currency).setTerm(SDR).setFactor(new DefaultNumberValue(values[i])).build();
                    rates.add(rate);
                    continue;
                }
                rates = this.sdrToCurrency.get(currency);
                if (Objects.isNull(rates)) {
                    rates = new ArrayList<ExchangeRate>(5);
                    newSdrToCurrency.put(currency, rates);
                }
                rate = new ExchangeRateBuilder(((ConversionContextBuilder)ConversionContextBuilder.create((ProviderContext)CONTEXT, (RateType)rateType).setTimestampMillis(fromTS.longValue())).build()).setBase(SDR).setTerm(currency).setFactor(DefaultNumberValue.of(values[i])).build();
                rates.add(rate);
            }
            line = pr.readLine();
        }
        newSdrToCurrency.values().forEach(c -> Collections.sort((List)List.class.cast(c)));
        newCurrencyToSdr.values().forEach(c -> Collections.sort((List)List.class.cast(c)));
        this.sdrToCurrency = newSdrToCurrency;
        this.currencyToSdr = newCurrencyToSdr;
    }

    private Double[] parseValues(NumberFormat f, String[] parts) throws ParseException {
        Double[] result = new Double[parts.length - 1];
        for (int i = 1; i < parts.length; ++i) {
            if (parts[i].isEmpty()) continue;
            result[i - 1] = f.parse(parts[i]).doubleValue();
        }
        return result;
    }

    private List<Long> readTimestamps(String line) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("MMM DD, yyyy", Locale.ENGLISH);
        String[] parts = line.split("\\\t");
        ArrayList<Long> dates = new ArrayList<Long>(parts.length);
        for (int i = 1; i < parts.length; ++i) {
            dates.add(sdf.parse(parts[i]).getTime());
        }
        return dates;
    }

    @Override
    public ExchangeRate getExchangeRate(ConversionQuery conversionQuery) {
        if (!this.isAvailable(conversionQuery)) {
            return null;
        }
        CurrencyUnit base = conversionQuery.getBaseCurrency();
        CurrencyUnit term = conversionQuery.getCurrency();
        Long timestamp = conversionQuery.getTimestampMillis();
        ExchangeRate rate1 = this.lookupRate(this.currencyToSdr.get(base), timestamp);
        ExchangeRate rate2 = this.lookupRate(this.sdrToCurrency.get(term), timestamp);
        if (base.equals(SDR)) {
            return rate2;
        }
        if (term.equals(SDR)) {
            return rate1;
        }
        if (Objects.isNull(rate1) || Objects.isNull(rate2)) {
            return null;
        }
        ExchangeRateBuilder builder = new ExchangeRateBuilder(ConversionContext.of((String)CONTEXT.getProvider(), (RateType)RateType.HISTORIC));
        builder.setBase(base);
        builder.setTerm(term);
        builder.setFactor(IMFRateProvider.multiply(rate1.getFactor(), rate2.getFactor()));
        builder.setRateChain(rate1, rate2);
        return builder.build();
    }

    private ExchangeRate lookupRate(List<ExchangeRate> list, Long timestamp) {
        if (Objects.isNull(list)) {
            return null;
        }
        ExchangeRate found = null;
        for (ExchangeRate rate : list) {
            if (Objects.isNull(timestamp)) {
                timestamp = System.currentTimeMillis();
            }
            if (this.isValid(rate.getConversionContext(), timestamp)) {
                return rate;
            }
            if (!Objects.isNull(found)) continue;
            found = rate;
        }
        return found;
    }

    private boolean isValid(ConversionContext conversionContext, Long timestamp) {
        Long validFrom = conversionContext.getLong((Object)"validFrom", null);
        Long validTo = conversionContext.getLong((Object)"validTo", null);
        return !(Objects.nonNull(validFrom) && validFrom > timestamp || Objects.nonNull(validTo) && validTo < timestamp);
    }

    static {
        for (Currency currency : Currency.getAvailableCurrencies()) {
            currenciesByName.put(currency.getDisplayName(Locale.ENGLISH), MonetaryCurrencies.getCurrency((String)currency.getCurrencyCode(), (String[])new String[0]));
        }
        currenciesByName.put("U.K. Pound Sterling", MonetaryCurrencies.getCurrency((String)"GBP", (String[])new String[0]));
        currenciesByName.put("U.S. Dollar", MonetaryCurrencies.getCurrency((String)"USD", (String[])new String[0]));
        currenciesByName.put("Bahrain Dinar", MonetaryCurrencies.getCurrency((String)"BHD", (String[])new String[0]));
        currenciesByName.put("Botswana Pula", MonetaryCurrencies.getCurrency((String)"BWP", (String[])new String[0]));
        currenciesByName.put("Czech Koruna", MonetaryCurrencies.getCurrency((String)"CZK", (String[])new String[0]));
        currenciesByName.put("Icelandic Krona", MonetaryCurrencies.getCurrency((String)"ISK", (String[])new String[0]));
        currenciesByName.put("Korean Won", MonetaryCurrencies.getCurrency((String)"KRW", (String[])new String[0]));
        currenciesByName.put("Rial Omani", MonetaryCurrencies.getCurrency((String)"OMR", (String[])new String[0]));
        currenciesByName.put("Nuevo Sol", MonetaryCurrencies.getCurrency((String)"PEN", (String[])new String[0]));
        currenciesByName.put("Qatar Riyal", MonetaryCurrencies.getCurrency((String)"QAR", (String[])new String[0]));
        currenciesByName.put("Saudi Arabian Riyal", MonetaryCurrencies.getCurrency((String)"SAR", (String[])new String[0]));
        currenciesByName.put("Sri Lanka Rupee", MonetaryCurrencies.getCurrency((String)"LKR", (String[])new String[0]));
        currenciesByName.put("Trinidad And Tobago Dollar", MonetaryCurrencies.getCurrency((String)"TTD", (String[])new String[0]));
        currenciesByName.put("U.A.E. Dirham", MonetaryCurrencies.getCurrency((String)"AED", (String[])new String[0]));
        currenciesByName.put("Peso Uruguayo", MonetaryCurrencies.getCurrency((String)"UYU", (String[])new String[0]));
        currenciesByName.put("Bolivar Fuerte", MonetaryCurrencies.getCurrency((String)"VEF", (String[])new String[0]));
    }
}

