/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.convert.internal;

import java.io.InputStream;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import javax.money.CurrencyUnit;
import javax.money.MonetaryCurrencies;
import javax.money.convert.ConversionContext;
import javax.money.convert.ConversionContextBuilder;
import javax.money.convert.ConversionQuery;
import javax.money.convert.ExchangeRate;
import javax.money.convert.ProviderContext;
import javax.money.convert.ProviderContextBuilder;
import javax.money.convert.RateType;
import javax.money.spi.Bootstrap;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.javamoney.moneta.ExchangeRateBuilder;
import org.javamoney.moneta.spi.AbstractRateProvider;
import org.javamoney.moneta.spi.DefaultNumberValue;
import org.javamoney.moneta.spi.LoaderService;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ECBHistoric90RateProvider
extends AbstractRateProvider
implements LoaderService.LoaderListener {
    private static final String DATA_ID = ECBHistoric90RateProvider.class.getSimpleName();
    private static final String BASE_CURRENCY_CODE = "EUR";
    public static final CurrencyUnit BASE_CURRENCY = MonetaryCurrencies.getCurrency((String)"EUR", (String[])new String[0]);
    private final Map<Long, Map<String, ExchangeRate>> rates = new ConcurrentHashMap<Long, Map<String, ExchangeRate>>();
    private SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
    private static final ProviderContext CONTEXT = ((ProviderContextBuilder)((ProviderContextBuilder)ProviderContextBuilder.of((String)"ECB-HIST90", (RateType)RateType.HISTORIC, (RateType[])new RateType[]{RateType.DEFERRED}).set((Object)"providerDescription", "European Central Bank (last 90 days)")).set((Object)"days", 90)).build();

    public ECBHistoric90RateProvider() throws MalformedURLException {
        super(CONTEXT);
        this.saxParserFactory.setNamespaceAware(false);
        this.saxParserFactory.setValidating(false);
        LoaderService loader = (LoaderService)Bootstrap.getService(LoaderService.class);
        loader.addLoaderListener(this, DATA_ID);
        loader.loadDataAsync(DATA_ID);
    }

    @Override
    public void newDataLoaded(String data, InputStream is) {
        int oldSize = this.rates.size();
        try {
            SAXParser parser = this.saxParserFactory.newSAXParser();
            parser.parse(is, (DefaultHandler)new RateReadingHandler());
        }
        catch (Exception e) {
            this.LOGGER.log(Level.FINEST, "Error during data load.", e);
        }
        int newSize = this.rates.size();
        this.LOGGER.info("Loaded " + DATA_ID + " exchange rates for days:" + (newSize - oldSize));
    }

    @Override
    public ExchangeRate getExchangeRate(ConversionQuery conversionQuery) {
        if (Objects.isNull(conversionQuery.getTimestampMillis())) {
            return null;
        }
        ExchangeRateBuilder builder = new ExchangeRateBuilder(((ConversionContextBuilder)ConversionContextBuilder.create((ProviderContext)CONTEXT, (RateType)RateType.HISTORIC).setTimestampMillis(conversionQuery.getTimestampMillis().longValue())).build());
        if (this.rates.isEmpty()) {
            return null;
        }
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        cal.setTimeInMillis(conversionQuery.getTimestampMillis());
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Long targetTS = cal.getTimeInMillis();
        builder.setBase(conversionQuery.getBaseCurrency());
        builder.setTerm(conversionQuery.getCurrency());
        Map<String, ExchangeRate> targets = this.rates.get(targetTS);
        if (Objects.isNull(targets)) {
            return null;
        }
        ExchangeRate sourceRate = targets.get(conversionQuery.getBaseCurrency().getCurrencyCode());
        ExchangeRate target = targets.get(conversionQuery.getCurrency().getCurrencyCode());
        if (BASE_CURRENCY_CODE.equals(conversionQuery.getBaseCurrency().getCurrencyCode()) && BASE_CURRENCY_CODE.equals(conversionQuery.getCurrency().getCurrencyCode())) {
            builder.setFactor(DefaultNumberValue.ONE);
            return builder.build();
        }
        if (BASE_CURRENCY_CODE.equals(conversionQuery.getCurrency().getCurrencyCode())) {
            if (Objects.isNull(sourceRate)) {
                return null;
            }
            return this.getReversed(sourceRate);
        }
        if (BASE_CURRENCY_CODE.equals(conversionQuery.getBaseCurrency().getCurrencyCode())) {
            return target;
        }
        ExchangeRate rate1 = this.getExchangeRate(conversionQuery.toBuilder().setBaseCurrency(conversionQuery.getBaseCurrency()).setTermCurrency(MonetaryCurrencies.getCurrency((String)BASE_CURRENCY_CODE, (String[])new String[0])).build());
        ExchangeRate rate2 = this.getExchangeRate(conversionQuery.toBuilder().setBaseCurrency(MonetaryCurrencies.getCurrency((String)BASE_CURRENCY_CODE, (String[])new String[0])).setTermCurrency(conversionQuery.getCurrency()).build());
        if (Objects.nonNull(rate1) || Objects.nonNull(rate2)) {
            builder.setFactor(ECBHistoric90RateProvider.multiply(rate1.getFactor(), rate2.getFactor()));
            builder.setRateChain(rate1, rate2);
            return builder.build();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addRate(CurrencyUnit term, Long timestamp, Number rate) {
        ExchangeRateBuilder builder;
        RateType rateType = RateType.HISTORIC;
        if (Objects.nonNull(timestamp)) {
            if (timestamp > System.currentTimeMillis()) {
                rateType = RateType.DEFERRED;
            }
            builder = new ExchangeRateBuilder(((ConversionContextBuilder)ConversionContextBuilder.create((ProviderContext)CONTEXT, (RateType)rateType).setTimestampMillis(timestamp.longValue())).build());
        } else {
            builder = new ExchangeRateBuilder(ConversionContext.of((String)CONTEXT.getProvider(), (RateType)rateType));
        }
        builder.setBase(BASE_CURRENCY);
        builder.setTerm(term);
        builder.setFactor(new DefaultNumberValue(rate));
        ExchangeRate exchangeRate = builder.build();
        Map rateMap = this.rates.get(timestamp);
        if (Objects.isNull(rateMap)) {
            Map<Long, Map<String, ExchangeRate>> map = this.rates;
            synchronized (map) {
                rateMap = Optional.ofNullable(this.rates.get(timestamp)).orElse(new ConcurrentHashMap());
                this.rates.putIfAbsent(timestamp, rateMap);
            }
        }
        rateMap.put((String)term.getCurrencyCode(), (ExchangeRate)exchangeRate);
    }

    private class RateReadingHandler
    extends DefaultHandler {
        private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        private Long timestamp;

        public RateReadingHandler() {
            this.dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            try {
                if ("Cube".equals(qName)) {
                    if (Objects.nonNull(attributes.getValue("time"))) {
                        Date date = this.dateFormat.parse(attributes.getValue("time"));
                        this.timestamp = date.getTime();
                    } else if (Objects.nonNull(attributes.getValue("currency"))) {
                        CurrencyUnit tgtCurrency = MonetaryCurrencies.getCurrency((String)attributes.getValue("currency"), (String[])new String[0]);
                        ECBHistoric90RateProvider.this.addRate(tgtCurrency, this.timestamp, BigDecimal.valueOf(Double.parseDouble(attributes.getValue("rate"))));
                    }
                }
                super.startElement(uri, localName, qName, attributes);
            }
            catch (ParseException e) {
                throw new SAXException("Failed to read.", e);
            }
        }
    }
}

