/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Objects;
import javax.money.CurrencyUnit;
import javax.money.MonetaryAmount;
import javax.money.MonetaryAmountFactory;
import javax.money.MonetaryContext;
import javax.money.MonetaryCurrencies;
import javax.money.MonetaryException;
import javax.money.MonetaryOperator;
import javax.money.MonetaryQuery;
import javax.money.NumberValue;
import javax.money.format.MonetaryAmountFormat;
import org.javamoney.moneta.DefaultMonetaryContextFactory;
import org.javamoney.moneta.ToStringMonetaryAmountFormat;
import org.javamoney.moneta.internal.MoneyAmountBuilder;
import org.javamoney.moneta.spi.DefaultNumberValue;
import org.javamoney.moneta.spi.MoneyUtils;

public final class Money
implements MonetaryAmount,
Comparable<MonetaryAmount>,
Serializable {
    private static final long serialVersionUID = -7565813772046251748L;
    public static final MonetaryContext DEFAULT_MONETARY_CONTEXT = new DefaultMonetaryContextFactory().getContext();
    private final CurrencyUnit currency;
    private final MonetaryContext monetaryContext;
    private BigDecimal number;
    private transient NumberValue numberValue;
    private static ToStringMonetaryAmountFormat DEFAULT_FORMATTER = ToStringMonetaryAmountFormat.of(ToStringMonetaryAmountFormat.ToStringMonetaryAmountFormatStyle.MONEY);

    private Money(BigDecimal number, CurrencyUnit currency) {
        this(number, currency, null);
    }

    private Money(BigDecimal number, CurrencyUnit currency, MonetaryContext monetaryContext) {
        Objects.requireNonNull(currency, "Currency is required.");
        this.currency = currency;
        this.monetaryContext = Objects.nonNull(monetaryContext) ? monetaryContext : DEFAULT_MONETARY_CONTEXT;
        Objects.requireNonNull(number, "Number is required.");
        this.number = MoneyUtils.getBigDecimal(number, monetaryContext);
    }

    public CurrencyUnit getCurrency() {
        return this.currency;
    }

    public MonetaryContext getMonetaryContext() {
        return this.monetaryContext;
    }

    public NumberValue getNumber() {
        if (Objects.isNull(this.numberValue)) {
            this.numberValue = new DefaultNumberValue(this.number);
        }
        return this.numberValue;
    }

    public BigDecimal getNumberStripped() {
        if (this.isZero()) {
            return BigDecimal.ZERO;
        }
        return this.number.stripTrailingZeros();
    }

    @Override
    public int compareTo(MonetaryAmount o) {
        Objects.requireNonNull(o);
        int compare = this.getCurrency().getCurrencyCode().compareTo(o.getCurrency().getCurrencyCode());
        if (compare == 0) {
            compare = this.number.compareTo(Money.from((MonetaryAmount)o).number);
        }
        return compare;
    }

    public Money abs() {
        if (this.isPositiveOrZero()) {
            return this;
        }
        return this.negate();
    }

    public Money divide(long divisor) {
        if (divisor == 1L) {
            return this;
        }
        return this.divide(BigDecimal.valueOf(divisor));
    }

    public Money divide(double divisor) {
        if (divisor == 1.0) {
            return this;
        }
        return this.divide(new BigDecimal(String.valueOf(divisor)));
    }

    public Money[] divideAndRemainder(long divisor) {
        if (divisor == 1L) {
            return new Money[]{this, Money.of((Number)0L, this.getCurrency())};
        }
        return this.divideAndRemainder(BigDecimal.valueOf(divisor));
    }

    public Money[] divideAndRemainder(double divisor) {
        return this.divideAndRemainder(new BigDecimal(String.valueOf(divisor)));
    }

    public Money multiply(long multiplicand) {
        if (multiplicand == 1L) {
            return this;
        }
        return this.multiply(BigDecimal.valueOf(multiplicand));
    }

    public Money multiply(double multiplicand) {
        if (multiplicand == 1.0) {
            return this;
        }
        return this.multiply(new BigDecimal(String.valueOf(multiplicand)));
    }

    public Money remainder(long divisor) {
        if (divisor == 1L) {
            return this;
        }
        return this.remainder(BigDecimal.valueOf(divisor));
    }

    public Money remainder(double divisor) {
        return this.remainder(new BigDecimal(String.valueOf(divisor)));
    }

    public boolean isZero() {
        return this.signum() == 0;
    }

    public boolean isPositive() {
        return this.signum() == 1;
    }

    public boolean isPositiveOrZero() {
        return this.signum() >= 0;
    }

    public boolean isNegative() {
        return this.signum() == -1;
    }

    public boolean isNegativeOrZero() {
        return this.signum() <= 0;
    }

    public <R> R query(MonetaryQuery<R> query) {
        Objects.requireNonNull(query);
        try {
            return (R)query.queryFrom((MonetaryAmount)this);
        }
        catch (MonetaryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MonetaryException("Query failed: " + query, (Throwable)e);
        }
    }

    public Money with(MonetaryOperator operator) {
        Objects.requireNonNull(operator);
        try {
            return (Money)Money.class.cast(operator.apply((Object)this));
        }
        catch (MonetaryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MonetaryException("Operator failed: " + operator, (Throwable)e);
        }
    }

    public Money add(MonetaryAmount amount) {
        MoneyUtils.checkAmountParameter(amount, this.currency);
        if (amount.isZero()) {
            return this;
        }
        return new Money(this.number.add((BigDecimal)amount.getNumber().numberValue(BigDecimal.class)), this.getCurrency());
    }

    public Money divide(Number divisor) {
        BigDecimal divisorBD = MoneyUtils.getBigDecimal(divisor);
        if (divisorBD.equals(BigDecimal.ONE)) {
            return this;
        }
        BigDecimal dec = this.number.divide(divisorBD, MoneyUtils.getMathContext(this.getMonetaryContext(), RoundingMode.HALF_EVEN));
        return new Money(dec, this.getCurrency());
    }

    public Money[] divideAndRemainder(Number divisor) {
        BigDecimal divisorBD = MoneyUtils.getBigDecimal(divisor);
        if (divisorBD.equals(BigDecimal.ONE)) {
            return new Money[]{this, new Money(BigDecimal.ZERO, this.getCurrency())};
        }
        BigDecimal[] dec = this.number.divideAndRemainder(divisorBD);
        return new Money[]{new Money(dec[0], this.getCurrency()), new Money(dec[1], this.getCurrency())};
    }

    public Money divideToIntegralValue(long divisor) {
        return this.divideToIntegralValue(MoneyUtils.getBigDecimal(divisor));
    }

    public Money divideToIntegralValue(double divisor) {
        return this.divideToIntegralValue(MoneyUtils.getBigDecimal(divisor));
    }

    public Money divideToIntegralValue(Number divisor) {
        BigDecimal divisorBD = MoneyUtils.getBigDecimal(divisor);
        BigDecimal dec = this.number.divideToIntegralValue(divisorBD);
        return new Money(dec, this.getCurrency());
    }

    public Money multiply(Number multiplicand) {
        BigDecimal multiplicandBD = MoneyUtils.getBigDecimal(multiplicand);
        if (multiplicandBD.equals(BigDecimal.ONE)) {
            return this;
        }
        BigDecimal dec = this.number.multiply(multiplicandBD);
        return new Money(dec, this.getCurrency());
    }

    public Money negate() {
        return new Money(this.number.negate(), this.getCurrency());
    }

    public Money plus() {
        return new Money(this.number.plus(), this.getCurrency());
    }

    public Money subtract(MonetaryAmount subtrahend) {
        MoneyUtils.checkAmountParameter(subtrahend, this.currency);
        if (subtrahend.isZero()) {
            return this;
        }
        return new Money(this.number.subtract((BigDecimal)subtrahend.getNumber().numberValue(BigDecimal.class)), this.getCurrency());
    }

    public Money stripTrailingZeros() {
        if (this.isZero()) {
            return new Money(BigDecimal.ZERO, this.getCurrency());
        }
        return new Money(this.number.stripTrailingZeros(), this.getCurrency());
    }

    public Money remainder(Number divisor) {
        BigDecimal bd = MoneyUtils.getBigDecimal(divisor);
        return new Money(this.number.remainder(bd), this.getCurrency());
    }

    public Money scaleByPowerOfTen(int n) {
        return new Money(this.number.scaleByPowerOfTen(n), this.getCurrency());
    }

    public int signum() {
        return this.number.signum();
    }

    public boolean isLessThan(MonetaryAmount amount) {
        MoneyUtils.checkAmountParameter(amount, this.currency);
        return this.number.stripTrailingZeros().compareTo(((BigDecimal)amount.getNumber().numberValue(BigDecimal.class)).stripTrailingZeros()) < 0;
    }

    public boolean isLessThanOrEqualTo(MonetaryAmount amount) {
        MoneyUtils.checkAmountParameter(amount, this.currency);
        return this.number.stripTrailingZeros().compareTo(((BigDecimal)amount.getNumber().numberValue(BigDecimal.class)).stripTrailingZeros()) <= 0;
    }

    public boolean isGreaterThan(MonetaryAmount amount) {
        MoneyUtils.checkAmountParameter(amount, this.currency);
        return this.number.stripTrailingZeros().compareTo(((BigDecimal)amount.getNumber().numberValue(BigDecimal.class)).stripTrailingZeros()) > 0;
    }

    public boolean isGreaterThanOrEqualTo(MonetaryAmount amount) {
        MoneyUtils.checkAmountParameter(amount, this.currency);
        return this.number.stripTrailingZeros().compareTo(((BigDecimal)amount.getNumber().numberValue(BigDecimal.class)).stripTrailingZeros()) >= 0;
    }

    public boolean isEqualTo(MonetaryAmount amount) {
        MoneyUtils.checkAmountParameter(amount, this.currency);
        return this.number.stripTrailingZeros().compareTo(((BigDecimal)amount.getNumber().numberValue(BigDecimal.class)).stripTrailingZeros()) == 0;
    }

    public MonetaryAmountFactory<Money> getFactory() {
        return new MoneyAmountBuilder().setAmount(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Money) {
            Money other = (Money)obj;
            return Objects.equals(this.getCurrency(), other.getCurrency()) && Objects.equals(this.getNumberStripped(), other.getNumberStripped());
        }
        return false;
    }

    public String toString() {
        return this.getCurrency().getCurrencyCode() + ' ' + this.number.toString();
    }

    public int hashCode() {
        return Objects.hash(this.getCurrency(), this.getNumberStripped());
    }

    public static Money of(BigDecimal number, CurrencyUnit currency) {
        return new Money(number, currency);
    }

    public static Money of(BigDecimal number, CurrencyUnit currency, MonetaryContext monetaryContext) {
        return new Money(number, currency, monetaryContext);
    }

    public static Money of(Number number, CurrencyUnit currency) {
        return new Money(MoneyUtils.getBigDecimal(number), currency);
    }

    public static Money of(Number number, CurrencyUnit currency, MonetaryContext monetaryContext) {
        return new Money(MoneyUtils.getBigDecimal(number), currency, monetaryContext);
    }

    public static Money of(Number number, String currencyCode) {
        return new Money(MoneyUtils.getBigDecimal(number), MonetaryCurrencies.getCurrency((String)currencyCode, (String[])new String[0]));
    }

    public static Money of(BigDecimal number, String currencyCode) {
        return new Money(number, MonetaryCurrencies.getCurrency((String)currencyCode, (String[])new String[0]));
    }

    public static Money of(Number number, String currencyCode, MonetaryContext monetaryContext) {
        return new Money(MoneyUtils.getBigDecimal(number), MonetaryCurrencies.getCurrency((String)currencyCode, (String[])new String[0]), monetaryContext);
    }

    public static Money of(BigDecimal number, String currencyCode, MonetaryContext monetaryContext) {
        return new Money(number, MonetaryCurrencies.getCurrency((String)currencyCode, (String[])new String[0]), monetaryContext);
    }

    public static Money from(MonetaryAmount amt) {
        if (amt.getClass() == Money.class) {
            return (Money)amt;
        }
        return Money.of((BigDecimal)amt.getNumber().numberValue(BigDecimal.class), amt.getCurrency(), amt.getMonetaryContext());
    }

    public static Money parse(CharSequence text) {
        return Money.parse(text, DEFAULT_FORMATTER);
    }

    public static Money parse(CharSequence text, MonetaryAmountFormat formatter) {
        return Money.from(formatter.parse(text));
    }
}

