/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.spi.loader;

import org.javamoney.moneta.spi.LoadDataInformation;
import org.javamoney.moneta.spi.loader.LoadableResource;
import org.javamoney.moneta.spi.loader.ResourceCache;

public class LoadableResourceBuilder {
    private LoadDataInformation loadDataInformation;
    private ResourceCache cache;

    public LoadableResourceBuilder withLoadDataInformation(LoadDataInformation loadDataInformation) {
        this.loadDataInformation = loadDataInformation;
        return this;
    }

    public LoadableResourceBuilder withCache(ResourceCache cache) {
        this.cache = cache;
        return this;
    }

    public LoadableResource build() {
        if (this.cache == null) {
            throw new IllegalStateException("The cache should be informed");
        }
        if (this.loadDataInformation == null) {
            throw new IllegalStateException("The loadDataInformation should be informed");
        }
        return new LoadableResource(this.cache, this.loadDataInformation);
    }

    public String toString() {
        String sb = LoadableResourceBuilder.class.getName() + '{' + " loadDataInformation: " + this.loadDataInformation + ',' + " cache: " + this.loadDataInformation + '}';
        return sb;
    }
}

