/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.spi.loader;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.javamoney.moneta.spi.loader.DefaultLoaderListener;
import org.javamoney.moneta.spi.loader.LoadableResource;

class LoadRemoteDataLoaderService {
    private static final Logger LOG = Logger.getLogger(DefaultLoaderListener.class.getName());
    private final DefaultLoaderListener listener;

    LoadRemoteDataLoaderService(DefaultLoaderListener listener) {
        this.listener = listener;
    }

    public boolean execute(String resourceId, Map<String, LoadableResource> resources) {
        LoadableResource load = resources.get(resourceId);
        if (load != null) {
            try {
                load.readCache();
                this.listener.trigger(resourceId, load.getDataStream());
                load.loadRemote();
                this.listener.trigger(resourceId, load.getDataStream());
                LOG.log(Level.INFO, "The exchange rate with resourceId %s was started remotely", resourceId);
                return true;
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Failed to load resource: " + resourceId, e);
            }
        } else {
            throw new IllegalArgumentException("No such resource: " + resourceId);
        }
        return false;
    }

    public String toString() {
        return LoadRemoteDataLoaderService.class.getName() + '{' + " listener: " + this.listener + '}';
    }
}

