/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.spi.format;

import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.money.CurrencyUnit;
import javax.money.Monetary;
import javax.money.MonetaryAmount;
import javax.money.MonetaryAmountFactory;
import javax.money.format.AmountFormatContext;
import javax.money.format.AmountFormatContextBuilder;
import javax.money.format.MonetaryAmountFormat;
import javax.money.format.MonetaryParseException;
import org.javamoney.moneta.format.CurrencyStyle;
import org.javamoney.moneta.spi.format.AmountNumberToken;
import org.javamoney.moneta.spi.format.CurrencyToken;
import org.javamoney.moneta.spi.format.FormatToken;
import org.javamoney.moneta.spi.format.LiteralToken;
import org.javamoney.moneta.spi.format.ParseContext;

final class DefaultMonetaryAmountFormat
implements MonetaryAmountFormat {
    private static final char CURRENCY_SIGN = '\u00a4';
    private List<FormatToken> positiveTokens;
    private List<FormatToken> negativeTokens;
    private AmountFormatContext amountFormatContext;

    DefaultMonetaryAmountFormat(AmountFormatContext amountFormatContext) {
        Locale locale = amountFormatContext.getLocale();
        if (locale != null && "IN".equals(locale.getCountry()) && amountFormatContext.get("groupingSizes", int[].class) == null) {
            amountFormatContext = ((AmountFormatContextBuilder)amountFormatContext.toBuilder().set("groupingSizes", (Object)new int[]{3, 2})).build();
        }
        if (locale != null && "BG".equals(locale.getCountry())) {
            AmountFormatContextBuilder builder = amountFormatContext.toBuilder();
            if (amountFormatContext.get("groupingSizes", int[].class) == null) {
                ((AmountFormatContextBuilder)builder.set("groupingSizes", (Object)new int[]{3})).build();
            }
            if (amountFormatContext.get("groupingSeparators", int[].class) == null) {
                ((AmountFormatContextBuilder)builder.set("groupingSeparators", (Object)new String[]{"\u00a0"})).build();
            }
            amountFormatContext = builder.build();
        }
        this.setAmountFormatContext(amountFormatContext);
    }

    private void initPattern(String pattern, List<FormatToken> tokens, AmountFormatContext style) {
        int index = pattern.indexOf(164);
        if (index > 0) {
            String p1 = pattern.substring(0, index);
            String p2 = pattern.substring(index + 1);
            if (this.isLiteralPattern(p1)) {
                tokens.add(new LiteralToken(p1));
                tokens.add(new CurrencyToken((CurrencyStyle)((Object)style.get(CurrencyStyle.class)), (Locale)style.get(Locale.class)));
            } else {
                tokens.add(new AmountNumberToken(style, p1));
                tokens.add(new CurrencyToken((CurrencyStyle)((Object)style.get(CurrencyStyle.class)), (Locale)style.get(Locale.class)));
            }
            if (!p2.isEmpty()) {
                if (this.isLiteralPattern(p2)) {
                    tokens.add(new LiteralToken(p2));
                } else {
                    tokens.add(new AmountNumberToken(style, p2));
                }
            }
        } else if (index == 0) {
            tokens.add(new CurrencyToken((CurrencyStyle)((Object)style.get(CurrencyStyle.class)), (Locale)style.get(Locale.class)));
            tokens.add(new AmountNumberToken(style, pattern.substring(1)));
        } else {
            tokens.add(new AmountNumberToken(style, pattern));
        }
    }

    private boolean isLiteralPattern(String pattern) {
        return !pattern.contains("#") && !pattern.contains("0");
    }

    public String format(MonetaryAmount amount) {
        StringBuilder builder = new StringBuilder();
        try {
            this.print(builder, amount);
        }
        catch (IOException e) {
            throw new IllegalStateException("Error foratting of " + amount, e);
        }
        return builder.toString();
    }

    public void print(Appendable appendable, MonetaryAmount amount) throws IOException {
        if (amount.isNegative()) {
            for (FormatToken token : this.negativeTokens) {
                token.print(appendable, amount);
            }
        } else {
            for (FormatToken token : this.positiveTokens) {
                token.print(appendable, amount);
            }
        }
    }

    public MonetaryAmount parse(CharSequence text) throws MonetaryParseException {
        ParseContext ctx = new ParseContext(text);
        try {
            for (FormatToken token : this.positiveTokens) {
                token.parse(ctx);
            }
        }
        catch (Exception e) {
            Logger log = Logger.getLogger(this.getClass().getName());
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Failed to parse positive pattern, trying negative for: " + text, e);
            }
            for (FormatToken token : this.negativeTokens) {
                token.parse(ctx);
            }
        }
        CurrencyUnit unit = ctx.getParsedCurrency();
        Number num = ctx.getParsedNumber();
        if (unit == null) {
            unit = (CurrencyUnit)this.amountFormatContext.get(CurrencyUnit.class);
        }
        if (num == null) {
            throw new MonetaryParseException((CharSequence)text.toString(), -1);
        }
        MonetaryAmountFactory factory = this.amountFormatContext.getParseFactory();
        if (factory == null) {
            factory = Monetary.getDefaultAmountFactory();
        }
        return factory.setCurrency(unit).setNumber(num).create();
    }

    public String queryFrom(MonetaryAmount amount) {
        return this.format(amount);
    }

    public AmountFormatContext getContext() {
        return this.amountFormatContext;
    }

    private void setAmountFormatContext(AmountFormatContext amountFormatContext) {
        Objects.requireNonNull(amountFormatContext);
        this.amountFormatContext = amountFormatContext;
        this.positiveTokens = new ArrayList<FormatToken>();
        this.negativeTokens = new ArrayList<FormatToken>();
        String pattern = amountFormatContext.getText("pattern");
        if (pattern == null) {
            pattern = amountFormatContext.getLocale() != null && "BG".equals(amountFormatContext.getLocale().getCountry()) ? "#,##0.00 \u00a4" : (amountFormatContext.getLocale() != null && "IN".equals(amountFormatContext.getLocale().getCountry()) ? "\u00a4 #,##0.00" : ((DecimalFormat)DecimalFormat.getCurrencyInstance(amountFormatContext.getLocale())).toPattern());
        }
        if (pattern.indexOf(164) < 0) {
            this.positiveTokens.add(new AmountNumberToken(amountFormatContext, pattern));
            this.negativeTokens = this.positiveTokens;
        } else {
            char patternSeparator = ';';
            if (amountFormatContext.get(DecimalFormatSymbols.class) != null) {
                patternSeparator = ((DecimalFormatSymbols)amountFormatContext.get(DecimalFormatSymbols.class)).getPatternSeparator();
            }
            String[] plusMinusPatterns = pattern.split(String.valueOf(patternSeparator));
            this.initPattern(plusMinusPatterns[0], this.positiveTokens, amountFormatContext);
            if (plusMinusPatterns.length > 1) {
                this.initPattern(plusMinusPatterns[1], this.negativeTokens, amountFormatContext);
            } else {
                this.negativeTokens = this.positiveTokens;
            }
        }
    }
}

