/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Objects;
import javax.money.MonetaryAmount;
import javax.money.MonetaryAmountFactory;
import javax.money.MonetaryAmountFactoryQuery;
import javax.money.MonetaryContext;
import javax.money.MonetaryContextBuilder;
import javax.money.MonetaryException;
import javax.money.spi.Bootstrap;
import javax.money.spi.MonetaryAmountFactoryProviderSpi;
import org.javamoney.moneta.spi.base.BaseMonetaryAmountsSingletonQuerySpi;

public class DefaultMonetaryAmountsSingletonQuerySpi
extends BaseMonetaryAmountsSingletonQuerySpi {
    private static final Comparator<MonetaryAmountFactoryProviderSpi<? extends MonetaryAmount>> CONTEXT_COMPARATOR = new Comparator<MonetaryAmountFactoryProviderSpi<? extends MonetaryAmount>>(){

        @Override
        public int compare(MonetaryAmountFactoryProviderSpi<? extends MonetaryAmount> f1, MonetaryAmountFactoryProviderSpi<? extends MonetaryAmount> f2) {
            int compare = 0;
            MonetaryContext c1 = f1.getMaximalMonetaryContext();
            MonetaryContext c2 = f2.getMaximalMonetaryContext();
            if (c1.getPrecision() == 0 && c2.getPrecision() != 0) {
                compare = -1;
            }
            if (compare == 0 && c2.getPrecision() == 0 && c1.getPrecision() != 0) {
                compare = 1;
            }
            if (compare == 0 && c1.getPrecision() != 0 && c2.getPrecision() > c1.getPrecision()) {
                compare = 1;
            }
            if (compare == 0 && c2.getPrecision() != 0 && c2.getPrecision() < c1.getPrecision()) {
                compare = -1;
            }
            if (compare == 0 && c1.getMaxScale() > c2.getMaxScale()) {
                compare = -1;
            }
            if (compare == 0 && c1.getMaxScale() < c2.getMaxScale()) {
                compare = 1;
            }
            return compare;
        }
    };

    public Collection<MonetaryAmountFactory<?>> getAmountFactories(MonetaryAmountFactoryQuery factoryQuery) {
        Objects.requireNonNull(factoryQuery);
        ArrayList factories = new ArrayList();
        for (MonetaryAmountFactoryProviderSpi prov : Bootstrap.getServices(MonetaryAmountFactoryProviderSpi.class)) {
            if (prov.getQueryInclusionPolicy() == MonetaryAmountFactoryProviderSpi.QueryInclusionPolicy.NEVER || factoryQuery.getTargetType() != prov.getAmountType()) continue;
            if (this.isPrecisionOK(factoryQuery, prov.getMaximalMonetaryContext())) {
                factories.add(this.createFactory((MonetaryAmountFactoryProviderSpi<? extends MonetaryAmount>)prov, factoryQuery));
                continue;
            }
            throw new MonetaryException("Incompatible context required=" + factoryQuery + ", maximal=" + prov.getMaximalMonetaryContext());
        }
        ArrayList<MonetaryAmountFactoryProviderSpi> selection = new ArrayList<MonetaryAmountFactoryProviderSpi>();
        for (MonetaryAmountFactoryProviderSpi f : Bootstrap.getServices(MonetaryAmountFactoryProviderSpi.class)) {
            if (f.getQueryInclusionPolicy() == MonetaryAmountFactoryProviderSpi.QueryInclusionPolicy.DIRECT_REFERENCE_ONLY || f.getQueryInclusionPolicy() == MonetaryAmountFactoryProviderSpi.QueryInclusionPolicy.NEVER || !this.isPrecisionOK(factoryQuery, f.getMaximalMonetaryContext())) continue;
            selection.add(f);
        }
        if (selection.isEmpty()) {
            for (MonetaryAmountFactoryProviderSpi f : Bootstrap.getServices(MonetaryAmountFactoryProviderSpi.class)) {
                if (f.getQueryInclusionPolicy() == MonetaryAmountFactoryProviderSpi.QueryInclusionPolicy.DIRECT_REFERENCE_ONLY || f.getQueryInclusionPolicy() == MonetaryAmountFactoryProviderSpi.QueryInclusionPolicy.NEVER || !this.isPrecisionOK(factoryQuery, f.getMaximalMonetaryContext())) continue;
                selection.add(f);
            }
        }
        if (selection.size() == 1) {
            factories.add(this.createFactory((MonetaryAmountFactoryProviderSpi<? extends MonetaryAmount>)((MonetaryAmountFactoryProviderSpi)selection.get(0)), factoryQuery));
        }
        Collections.sort(selection, CONTEXT_COMPARATOR);
        factories.add(this.createFactory((MonetaryAmountFactoryProviderSpi<? extends MonetaryAmount>)((MonetaryAmountFactoryProviderSpi)selection.get(0)), factoryQuery));
        return factories;
    }

    private MonetaryAmountFactory<?> createFactory(MonetaryAmountFactoryProviderSpi<? extends MonetaryAmount> prov, MonetaryAmountFactoryQuery factoryQuery) {
        MonetaryAmountFactory factory = prov.createMonetaryAmountFactory();
        if (factoryQuery != null) {
            MonetaryContextBuilder cb = factory.getDefaultMonetaryContext().toBuilder();
            for (String key : factoryQuery.getKeys(Object.class)) {
                cb.set(key, factoryQuery.get(key, Object.class));
            }
            factory.setContext(cb.build());
        }
        return factory;
    }

    private boolean isPrecisionOK(MonetaryAmountFactoryQuery requiredContext, MonetaryContext maximalMonetaryContext) {
        if (maximalMonetaryContext.getPrecision() == 0) {
            return true;
        }
        if (requiredContext.getPrecision() != null) {
            if (requiredContext.getPrecision() == 0) {
                return false;
            }
            if (requiredContext.getPrecision() > maximalMonetaryContext.getPrecision()) {
                return false;
            }
        }
        return null == requiredContext.getMaxScale() || requiredContext.getMaxScale() <= maximalMonetaryContext.getMaxScale();
    }
}

