/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.spi;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.money.NumberValue;

public enum ConvertBigDecimal {
    INTEGER{

        @Override
        BigDecimal getDecimal(Number num) {
            return BigDecimal.valueOf(num.longValue());
        }
    }
    ,
    FLUCTUAGE{

        @Override
        BigDecimal getDecimal(Number num) {
            double d = num.doubleValue();
            if (Double.isNaN(d) || Double.isInfinite(d)) {
                throw new ArithmeticException("NaN, POSITIVE_INFINITY and NEGATIVE_INFINITY cannot be used as parameters for monetary operations.");
            }
            return new BigDecimal(num.toString());
        }
    }
    ,
    BIGINTEGER{

        @Override
        BigDecimal getDecimal(Number num) {
            return new BigDecimal((BigInteger)num);
        }
    }
    ,
    NUMBERVALUE{

        @Override
        BigDecimal getDecimal(Number num) {
            BigDecimal result = (BigDecimal)((NumberValue)num).numberValue(BigDecimal.class);
            return ConvertBigDecimal.isScaleZero(result);
        }
    }
    ,
    BIGDECIMAL{

        @Override
        BigDecimal getDecimal(Number num) {
            BigDecimal result = (BigDecimal)num;
            return ConvertBigDecimal.isScaleZero(result);
        }
    }
    ,
    BIGDECIMAL_EXTENDS{

        @Override
        BigDecimal getDecimal(Number num) {
            BigDecimal result = ((BigDecimal)num).stripTrailingZeros();
            return ConvertBigDecimal.isScaleZero(result);
        }
    }
    ,
    DEFAULT{

        @Override
        BigDecimal getDecimal(Number num) {
            BigDecimal result = null;
            try {
                result = new BigDecimal(num.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (result == null) {
                result = BigDecimal.valueOf(num.doubleValue());
            }
            return ConvertBigDecimal.isScaleZero(result);
        }
    };

    private static final List<Class> FLOATINGS;
    private static final List<Class> INSTEGERS;

    abstract BigDecimal getDecimal(Number var1);

    static BigDecimal of(Number num) {
        Objects.requireNonNull(num, "Number is required.");
        return ConvertBigDecimal.factory(num).getDecimal(num);
    }

    private static ConvertBigDecimal factory(Number num) {
        if (INSTEGERS.contains(num.getClass())) {
            return INTEGER;
        }
        if (FLOATINGS.contains(num.getClass())) {
            return FLUCTUAGE;
        }
        if (num instanceof NumberValue) {
            return NUMBERVALUE;
        }
        if (BigDecimal.class.equals(num.getClass())) {
            return BIGDECIMAL;
        }
        if (num instanceof BigInteger) {
            return BIGINTEGER;
        }
        if (num instanceof BigDecimal) {
            return BIGDECIMAL_EXTENDS;
        }
        return DEFAULT;
    }

    private static BigDecimal isScaleZero(BigDecimal result) {
        if (result.signum() == 0) {
            return BigDecimal.ZERO;
        }
        if (result.scale() > 0) {
            return result.stripTrailingZeros();
        }
        return result;
    }

    static {
        FLOATINGS = Arrays.asList(Float.class, Double.class);
        INSTEGERS = Arrays.asList(Long.class, Integer.class, Short.class, Byte.class, AtomicLong.class, AtomicInteger.class);
    }
}

