/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.spi;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Calendar;
import java.util.Objects;
import java.util.logging.Logger;
import javax.money.NumberValue;
import javax.money.convert.ConversionContext;
import javax.money.convert.ConversionQuery;
import javax.money.convert.CurrencyConversion;
import javax.money.convert.ExchangeRate;
import javax.money.convert.ProviderContext;
import javax.money.convert.RateType;
import org.javamoney.moneta.spi.DefaultNumberValue;
import org.javamoney.moneta.spi.LazyBoundCurrencyConversion;
import org.javamoney.moneta.spi.base.BaseExchangeRateProvider;

public abstract class AbstractRateProvider
extends BaseExchangeRateProvider {
    protected final Logger LOGGER = Logger.getLogger(this.getClass().getName());
    private final ProviderContext providerContext;

    public AbstractRateProvider(ProviderContext providerContext) {
        this.providerContext = Objects.requireNonNull(providerContext);
    }

    public ProviderContext getContext() {
        return this.providerContext;
    }

    public abstract ExchangeRate getExchangeRate(ConversionQuery var1);

    public CurrencyConversion getCurrencyConversion(ConversionQuery conversionQuery) {
        if (this.getContext().getRateTypes().size() == 1) {
            return new LazyBoundCurrencyConversion(conversionQuery, this, ConversionContext.of((String)this.getContext().getProviderName(), (RateType)((RateType)this.getContext().getRateTypes().iterator().next())));
        }
        return new LazyBoundCurrencyConversion(conversionQuery, this, ConversionContext.of((String)this.getContext().getProviderName(), (RateType)RateType.ANY));
    }

    protected static NumberValue multiply(NumberValue multiplicand, NumberValue multiplier) {
        if (multiplicand == null) {
            throw new ArithmeticException("The multiplicand cannot be null");
        }
        if (multiplier == null) {
            throw new ArithmeticException("The multiplier cannot be null");
        }
        return new DefaultNumberValue(((BigDecimal)multiplicand.numberValueExact(BigDecimal.class)).multiply((BigDecimal)multiplier.numberValue(BigDecimal.class)));
    }

    protected static NumberValue divide(NumberValue dividend, NumberValue divisor) {
        if (dividend == null) {
            throw new ArithmeticException("The dividend cannot be null");
        }
        if (divisor == null) {
            throw new ArithmeticException("The divisor cannot be null");
        }
        return new DefaultNumberValue(((BigDecimal)dividend.numberValueExact(BigDecimal.class)).divide((BigDecimal)divisor.numberValue(BigDecimal.class), RoundingMode.HALF_EVEN));
    }

    protected static NumberValue divide(NumberValue dividend, NumberValue divisor, MathContext context) {
        if (dividend == null) {
            throw new ArithmeticException("The dividend cannot be null");
        }
        if (divisor == null) {
            throw new ArithmeticException("The divisor cannot be null");
        }
        return new DefaultNumberValue(((BigDecimal)dividend.numberValueExact(BigDecimal.class)).divide((BigDecimal)divisor.numberValue(BigDecimal.class), context));
    }

    protected String formatLocalDate(Calendar calendar) {
        return calendar.get(1) + "-" + calendar.get(2) + "-" + calendar.get(5);
    }
}

