/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.spi;

import java.net.URI;
import java.util.Map;
import org.javamoney.moneta.spi.LoadDataInformation;
import org.javamoney.moneta.spi.LoaderService;

public class LoadDataInformationBuilder {
    private String resourceId;
    private LoaderService.UpdatePolicy updatePolicy;
    private Map<String, String> properties;
    private LoaderService.LoaderListener loaderListener;
    private URI backupResource;
    private URI[] resourceLocations;
    private boolean startRemote;

    public LoadDataInformationBuilder withResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    public LoadDataInformationBuilder withUpdatePolicy(LoaderService.UpdatePolicy updatePolicy) {
        this.updatePolicy = updatePolicy;
        return this;
    }

    public LoadDataInformationBuilder withProperties(Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    public LoadDataInformationBuilder withLoaderListener(LoaderService.LoaderListener loaderListener) {
        this.loaderListener = loaderListener;
        return this;
    }

    public LoadDataInformationBuilder withBackupResource(URI backupResource) {
        this.backupResource = backupResource;
        return this;
    }

    public LoadDataInformationBuilder withResourceLocations(URI ... resourceLocations) {
        this.resourceLocations = resourceLocations;
        return this;
    }

    public LoadDataInformationBuilder withStartRemote(boolean startRemote) {
        this.startRemote = startRemote;
        return this;
    }

    public LoadDataInformation build() {
        if (this.resourceId == null || this.resourceId.isEmpty()) {
            throw new IllegalStateException("The resourceId should be informed");
        }
        if (this.updatePolicy == null) {
            throw new IllegalStateException("The updatePolicy should be informed");
        }
        if (this.properties == null) {
            throw new IllegalStateException("The properties should be informed");
        }
        if (this.resourceLocations == null) {
            throw new IllegalStateException("The properties should be informed");
        }
        return new LoadDataInformation(this.resourceId, this.updatePolicy, this.properties, this.loaderListener, this.backupResource, this.resourceLocations, this.startRemote);
    }
}

