/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.spi;

import java.io.Serializable;
import java.util.Currency;
import java.util.Objects;
import javax.money.CurrencyContext;
import javax.money.CurrencyContextBuilder;
import javax.money.CurrencyUnit;

public final class JDKCurrencyAdapter
implements CurrencyUnit,
Serializable,
Comparable<CurrencyUnit> {
    private static final long serialVersionUID = -798486953910548549L;
    private final Currency baseCurrency;
    private final CurrencyContext CONTEXT = CurrencyContextBuilder.of((String)Currency.class.getName()).build();

    JDKCurrencyAdapter(Currency currency) {
        this.baseCurrency = currency;
    }

    public String getCurrencyCode() {
        return this.baseCurrency.getCurrencyCode();
    }

    public int getNumericCode() {
        return this.baseCurrency.getNumericCode();
    }

    public int getDefaultFractionDigits() {
        return this.baseCurrency.getDefaultFractionDigits();
    }

    public CurrencyContext getContext() {
        return this.CONTEXT;
    }

    @Override
    public int compareTo(CurrencyUnit currency) {
        Objects.requireNonNull(currency);
        return this.getCurrencyCode().compareTo(currency.getCurrencyCode());
    }

    public int hashCode() {
        return Objects.hashCode(this.baseCurrency);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CurrencyUnit) {
            CurrencyUnit other = (CurrencyUnit)obj;
            return Objects.equals(this.getCurrencyCode(), other.getCurrencyCode());
        }
        return false;
    }

    public String toString() {
        return this.baseCurrency.toString();
    }
}

