/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.spi;

import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Set;
import javax.money.CurrencyUnit;
import javax.money.Monetary;
import javax.money.MonetaryRounding;
import javax.money.RoundingQuery;
import javax.money.spi.RoundingProviderSpi;
import org.javamoney.moneta.spi.DefaultCashRounding;
import org.javamoney.moneta.spi.DefaultRounding;

public class DefaultRoundingProvider
implements RoundingProviderSpi {
    private static final String DEFAULT_ROUNDING_NAME = "default";
    private Set<String> roundingsNames = new HashSet<String>();

    public DefaultRoundingProvider() {
        this.roundingsNames.add(DEFAULT_ROUNDING_NAME);
        this.roundingsNames = Collections.unmodifiableSet(this.roundingsNames);
    }

    public String getProviderName() {
        return DEFAULT_ROUNDING_NAME;
    }

    public MonetaryRounding getRounding(RoundingQuery roundingQuery) {
        if (roundingQuery.get(GregorianCalendar.class) != null || roundingQuery.get(Calendar.class) != null) {
            return null;
        }
        CurrencyUnit currency = roundingQuery.getCurrency();
        if (currency != null) {
            RoundingMode roundingMode = (RoundingMode)((Object)roundingQuery.get(RoundingMode.class));
            if (roundingMode == null) {
                roundingMode = RoundingMode.HALF_EVEN;
            }
            if (Boolean.TRUE.equals(roundingQuery.getBoolean("cashRounding"))) {
                if (currency.getCurrencyCode().equals("CHF")) {
                    return new DefaultCashRounding(currency, RoundingMode.HALF_UP, 5);
                }
                return new DefaultCashRounding(currency, 1);
            }
            return new DefaultRounding(currency, roundingMode);
        }
        Integer scale = roundingQuery.getScale();
        if (scale == null) {
            scale = 2;
        }
        MathContext mc = (MathContext)roundingQuery.get(MathContext.class);
        RoundingMode roundingMode = (RoundingMode)((Object)roundingQuery.get(RoundingMode.class));
        if (mc != null) {
            return new DefaultRounding(scale, mc.getRoundingMode());
        }
        if (roundingMode != null) {
            return new DefaultRounding(scale, roundingMode);
        }
        if (roundingQuery.getRoundingName() != null && DEFAULT_ROUNDING_NAME.equals(roundingQuery.getRoundingName())) {
            return Monetary.getDefaultRounding();
        }
        return null;
    }

    public Set<String> getRoundingNames() {
        return this.roundingsNames;
    }
}

