/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.spi;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.money.MonetaryAmount;
import javax.money.MonetaryAmountFactory;
import javax.money.MonetaryException;
import javax.money.spi.Bootstrap;
import javax.money.spi.MonetaryAmountFactoryProviderSpi;
import org.javamoney.moneta.spi.base.BaseMonetaryAmountsSingletonSpi;

public class DefaultMonetaryAmountsSingletonSpi
extends BaseMonetaryAmountsSingletonSpi {
    private final Map<Class<? extends MonetaryAmount>, MonetaryAmountFactoryProviderSpi<?>> factories = new ConcurrentHashMap();
    private Class<? extends MonetaryAmount> configuredDefaultAmountType = this.loadDefaultAmountType();

    public DefaultMonetaryAmountsSingletonSpi() {
        for (MonetaryAmountFactoryProviderSpi f : Bootstrap.getServices(MonetaryAmountFactoryProviderSpi.class)) {
            MonetaryAmountFactoryProviderSpi<?> factory = this.factories.get(f.getAmountType());
            if (factory != null) continue;
            this.factories.put(f.getAmountType(), f);
        }
    }

    private Class<? extends MonetaryAmount> loadDefaultAmountType() {
        return null;
    }

    public <T extends MonetaryAmount> MonetaryAmountFactory<T> getAmountFactory(Class<T> amountType) {
        MonetaryAmountFactoryProviderSpi f = (MonetaryAmountFactoryProviderSpi)MonetaryAmountFactoryProviderSpi.class.cast(this.factories.get(amountType));
        if (f != null) {
            return f.createMonetaryAmountFactory();
        }
        throw new MonetaryException("No matching MonetaryAmountFactory found, type=" + amountType.getName());
    }

    public Set<Class<? extends MonetaryAmount>> getAmountTypes() {
        return this.factories.keySet();
    }

    public Class<? extends MonetaryAmount> getDefaultAmountType() {
        if (this.configuredDefaultAmountType == null) {
            for (MonetaryAmountFactoryProviderSpi f : Bootstrap.getServices(MonetaryAmountFactoryProviderSpi.class)) {
                if (f.getQueryInclusionPolicy() != MonetaryAmountFactoryProviderSpi.QueryInclusionPolicy.ALWAYS) continue;
                this.configuredDefaultAmountType = f.getAmountType();
                break;
            }
        }
        if (this.configuredDefaultAmountType == null) {
            throw new MonetaryException("No MonetaryAmountFactoryProviderSpi registered.");
        }
        return this.configuredDefaultAmountType;
    }
}

