/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.convert;

import java.io.Serializable;
import java.util.Calendar;
import java.util.GregorianCalendar;

public final class LocalDate
implements Comparable<LocalDate>,
Serializable {
    private static final long serialVersionUID = 8427707792648468834L;
    final int year;
    final int month;
    final int dayOfMonth;

    LocalDate(int year, int month, int dayOfMonth) {
        this.year = year;
        this.month = month;
        this.dayOfMonth = dayOfMonth;
    }

    static LocalDate now() {
        Calendar cal = GregorianCalendar.getInstance();
        return LocalDate.from(cal);
    }

    static LocalDate yesterday() {
        return LocalDate.beforeDays(1);
    }

    static LocalDate beforeDays(int days) {
        Calendar cal = GregorianCalendar.getInstance();
        cal.add(6, days * -1);
        return LocalDate.from(cal);
    }

    public LocalDate minusDays(int days) {
        Calendar cal = this.toCalendar();
        cal.add(6, days * -1);
        return LocalDate.from(cal);
    }

    public Calendar toCalendar() {
        return new GregorianCalendar(this.year, this.month - 1, this.dayOfMonth);
    }

    public static LocalDate from(Calendar cal) {
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int dayOfMonth = cal.get(5);
        return new LocalDate(year, month, dayOfMonth);
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDayOfMonth() {
        return this.dayOfMonth;
    }

    public boolean before(LocalDate localDate) {
        return this.compareTo(localDate) < 0;
    }

    public boolean after(LocalDate localDate) {
        return this.compareTo(localDate) > 0;
    }

    @Override
    public int compareTo(LocalDate o) {
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LocalDate)) {
            return false;
        }
        LocalDate localDate = (LocalDate)o;
        return this.dayOfMonth == localDate.dayOfMonth && this.month == localDate.month && this.year == localDate.year;
    }

    public int hashCode() {
        int result = this.year;
        result = 31 * result + this.month;
        result = 31 * result + this.dayOfMonth;
        return result;
    }

    public String toString() {
        return "LocalDate{year=" + this.year + ", month=" + this.month + ", dayOfMonth=" + this.dayOfMonth + '}';
    }
}

