/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.validation;

import java.text.NumberFormat;
import java.text.ParsePosition;
import org.javalite.common.ConversionException;
import org.javalite.common.Convert;
import org.javalite.validation.Validatable;
import org.javalite.validation.ValidatorAdapter;

public class NumericValidator
extends ValidatorAdapter {
    private final String attribute;
    private Double min;
    private Double max;
    private boolean allowNull;
    private boolean onlyInteger;

    public NumericValidator(String attribute) {
        this.attribute = attribute;
    }

    @Override
    public void validate(Validatable validatable) {
        Object value = validatable.get(this.attribute);
        if (!this.present(value)) {
            this.setMessage("value is missing");
            validatable.addFailedValidator(this, this.attribute);
            return;
        }
        if (value == null && this.allowNull) {
            return;
        }
        if (!(value instanceof Number)) {
            if (value != null) {
                ParsePosition pp = new ParsePosition(0);
                String input = value.toString();
                NumberFormat nf = NumberFormat.getInstance();
                nf.setParseIntegerOnly(this.onlyInteger);
                nf.parse(input, pp);
                if (pp.getIndex() != input.length()) {
                    validatable.addFailedValidator(this, this.attribute);
                    this.setMessage("value is not a number");
                }
            } else {
                validatable.addFailedValidator(this, this.attribute);
            }
        }
        if (this.min != null) {
            try {
                this.validateMin(Convert.toDouble(value), validatable);
            }
            catch (ConversionException e) {
                validatable.addFailedValidator(this, this.attribute);
                this.setMessage(e.getMessage());
            }
        }
        if (this.max != null) {
            try {
                this.validateMax(Convert.toDouble(value), validatable);
            }
            catch (ConversionException e) {
                validatable.addFailedValidator(this, this.attribute);
                this.setMessage(e.getMessage());
            }
        }
        if (this.onlyInteger) {
            this.validateIntegerOnly(value, validatable);
        }
    }

    private void validateMin(Double value, Validatable validatable) {
        if (value <= this.min) {
            this.setMessage("value is less than " + this.min);
            validatable.addFailedValidator(this, this.attribute);
        }
    }

    private boolean present(Object value) {
        if (this.allowNull) {
            return true;
        }
        return value != null;
    }

    private void validateIntegerOnly(Object value, Validatable validatable) {
        try {
            Integer.valueOf(value.toString());
        }
        catch (NumberFormatException e) {
            this.setMessage("value is not an integer");
            validatable.addFailedValidator(this, this.attribute);
        }
    }

    private void validateMax(Double value, Validatable validatable) {
        if (value >= this.max) {
            this.setMessage("value is greater than " + this.max);
            validatable.addFailedValidator(this, this.attribute);
        }
    }

    public void setMin(Double min) {
        this.min = min;
    }

    public void setMax(Double max) {
        this.max = max;
    }

    public void setAllowNull(Boolean allowNull) {
        this.allowNull = allowNull;
    }

    public void setOnlyInteger(boolean onlyInteger) {
        this.onlyInteger = onlyInteger;
    }
}

