/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.validation;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.javalite.common.Util;
import org.javalite.validation.Validatable;
import org.javalite.validation.ValidatorAdapter;

public class DateValidator
extends ValidatorAdapter {
    private String attributeName;
    private String format;
    private SimpleDateFormat df;
    private final ThreadLocal<DateFormat> threadLocalFormat = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return (DateFormat)DateValidator.this.df.clone();
        }
    };

    public DateValidator(String attributeName, String format) {
        this.attributeName = attributeName;
        this.setMessage("attribute {0} does not conform to format: {1}");
        this.df = new SimpleDateFormat(format);
        this.format = format;
    }

    @Override
    public void validate(Validatable validatable) {
        Object val = validatable.get(this.attributeName);
        if (!(val instanceof Date) && !Util.blank(val)) {
            try {
                this.threadLocalFormat.get().parse(val.toString()).getTime();
            }
            catch (ParseException e) {
                validatable.addFailedValidator(this, this.attributeName);
            }
        }
    }

    @Override
    public String formatMessage(Locale locale, Object ... params) {
        return super.formatMessage(locale, this.attributeName, this.format);
    }
}

